/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.moment;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Mean;
import io.virtdata.shaded.oac.statistics.descriptive.moment.ThirdMoment;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class Skewness
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    protected ThirdMoment moment = null;
    protected boolean incMoment;

    public Skewness() {
        this.incMoment = true;
        this.moment = new ThirdMoment();
    }

    public Skewness(ThirdMoment thirdMoment) {
        this.incMoment = false;
        this.moment = thirdMoment;
    }

    public Skewness(Skewness skewness) throws NullArgumentException {
        Skewness.copy(skewness, this);
    }

    @Override
    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    @Override
    public double getResult() {
        if (this.moment.n < 3L) {
            return Double.NaN;
        }
        double d = this.moment.m2 / (double)(this.moment.n - 1L);
        if (d < 1.0E-19) {
            return 0.0;
        }
        double d2 = this.moment.getN();
        return d2 * this.moment.m3 / ((d2 - 1.0) * (d2 - 2.0) * FastMath.sqrt(d) * d);
    }

    @Override
    public long getN() {
        return this.moment.getN();
    }

    @Override
    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, n, n2) && n2 > 2) {
            Mean mean = new Mean();
            double d2 = mean.evaluate(dArray, n, n2);
            double d3 = 0.0;
            double d4 = 0.0;
            for (int i = n; i < n + n2; ++i) {
                double d5 = dArray[i] - d2;
                d3 += d5 * d5;
                d4 += d5;
            }
            double d6 = (d3 - d4 * d4 / (double)n2) / (double)(n2 - 1);
            double d7 = 0.0;
            for (int i = n; i < n + n2; ++i) {
                double d8 = dArray[i] - d2;
                d7 += d8 * d8 * d8;
            }
            double d9 = n2;
            d = d9 / ((d9 - 1.0) * (d9 - 2.0)) * (d7 /= d6 * FastMath.sqrt(d6));
        }
        return d;
    }

    @Override
    public Skewness copy() {
        Skewness skewness = new Skewness();
        Skewness.copy(this, skewness);
        return skewness;
    }

    public static void copy(Skewness skewness, Skewness skewness2) throws NullArgumentException {
        MathUtils.checkNotNull(skewness);
        MathUtils.checkNotNull(skewness2);
        skewness2.moment = new ThirdMoment(skewness.moment.copy());
        skewness2.incMoment = skewness.incMoment;
    }
}

