/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.moment;

import io.virtdata.shaded.oac.statistics.descriptive.moment.Mean;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math4.exception.DimensionMismatchException;

public class VectorialMean
implements Serializable {
    private static final long serialVersionUID = 8223009086481006892L;
    private final Mean[] means;

    public VectorialMean(int n) {
        this.means = new Mean[n];
        for (int i = 0; i < n; ++i) {
            this.means[i] = new Mean();
        }
    }

    public void increment(double[] dArray) throws DimensionMismatchException {
        if (dArray.length != this.means.length) {
            throw new DimensionMismatchException(dArray.length, this.means.length);
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.means[i].increment(dArray[i]);
        }
    }

    public double[] getResult() {
        double[] dArray = new double[this.means.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.means[i].getResult();
        }
        return dArray;
    }

    public long getN() {
        return this.means.length == 0 ? 0L : this.means[0].getN();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.means);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VectorialMean)) {
            return false;
        }
        VectorialMean vectorialMean = (VectorialMean)object;
        return Arrays.equals(this.means, vectorialMean.means);
    }
}

