/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import java.io.Serializable;
import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math4.distribution.RealDistribution;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformContinuousSampler;

public abstract class AbstractRealDistribution
implements RealDistribution,
Serializable {
    public static final double SOLVER_DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private static final long serialVersionUID = 20160311L;

    @Override
    public double probability(double d, double d2) {
        if (d > d2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)d, d2, true);
        }
        return this.cumulativeProbability(d2) - this.cumulativeProbability(d);
    }

    @Override
    public double inverseCumulativeProbability(final double d) throws OutOfRangeException {
        double d2;
        boolean bl;
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        double d3 = this.getSupportLowerBound();
        if (d == 0.0) {
            return d3;
        }
        double d4 = this.getSupportUpperBound();
        if (d == 1.0) {
            return d4;
        }
        double d5 = this.getMean();
        double d6 = FastMath.sqrt(this.getVariance());
        boolean bl2 = bl = !Double.isInfinite(d5) && !Double.isNaN(d5) && !Double.isInfinite(d6) && !Double.isNaN(d6);
        if (d3 == Double.NEGATIVE_INFINITY) {
            if (bl) {
                d3 = d5 - d6 * FastMath.sqrt((1.0 - d) / d);
            } else {
                d3 = -1.0;
                while (this.cumulativeProbability(d3) >= d) {
                    d3 *= 2.0;
                }
            }
        }
        if (d4 == Double.POSITIVE_INFINITY) {
            if (bl) {
                d4 = d5 + d6 * FastMath.sqrt(d / (1.0 - d));
            } else {
                d4 = 1.0;
                while (this.cumulativeProbability(d4) < d) {
                    d4 *= 2.0;
                }
            }
        }
        UnivariateFunction univariateFunction = new UnivariateFunction(){

            @Override
            public double value(double d2) {
                return AbstractRealDistribution.this.cumulativeProbability(d2) - d;
            }
        };
        double d7 = UnivariateSolverUtils.solve(univariateFunction, d3, d4, this.getSolverAbsoluteAccuracy());
        if (!this.isSupportConnected() && d7 - (d2 = this.getSolverAbsoluteAccuracy()) >= this.getSupportLowerBound()) {
            double d8 = this.cumulativeProbability(d7);
            if (this.cumulativeProbability(d7 - d2) == d8) {
                d4 = d7;
                while (d4 - d3 > d2) {
                    double d9 = 0.5 * (d3 + d4);
                    if (this.cumulativeProbability(d9) < d8) {
                        d3 = d9;
                        continue;
                    }
                    d4 = d9;
                }
                return d4;
            }
        }
        return d7;
    }

    protected double getSolverAbsoluteAccuracy() {
        return 1.0E-6;
    }

    @Override
    public double probability(double d) {
        return 0.0;
    }

    @Override
    public double logDensity(double d) {
        return FastMath.log(this.density(d));
    }

    public static double[] sample(int n, ContinuousDistribution.Sampler sampler) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = sampler.sample();
        }
        return dArray;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new InverseTransformContinuousSampler(uniformRandomProvider, AbstractRealDistribution.this.createICPF());
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }

    private ContinuousInverseCumulativeProbabilityFunction createICPF() {
        return new ContinuousInverseCumulativeProbabilityFunction(){

            @Override
            public double inverseCumulativeProbability(double d) {
                return AbstractRealDistribution.this.inverseCumulativeProbability(d);
            }
        };
    }
}

