/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.io.Serializable;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathIllegalStateException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.AbstractRealMatrix;
import org.apache.commons.math4.linear.MatrixDimensionMismatchException;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealMatrixChangingVisitor;
import org.apache.commons.math4.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math4.util.MathUtils;

public class Array2DRowRealMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = -1067294169172445528L;
    private double[][] data;

    public Array2DRowRealMatrix() {
    }

    public Array2DRowRealMatrix(int n, int n2) throws NotStrictlyPositiveException {
        super(n, n2);
        this.data = new double[n][n2];
    }

    public Array2DRowRealMatrix(double[][] dArray) throws DimensionMismatchException, NoDataException, NullArgumentException {
        this.copyIn(dArray);
    }

    public Array2DRowRealMatrix(double[][] dArray, boolean bl) throws DimensionMismatchException, NoDataException, NullArgumentException {
        if (bl) {
            this.copyIn(dArray);
        } else {
            if (dArray == null) {
                throw new NullArgumentException();
            }
            int n = dArray.length;
            if (n == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int n2 = dArray[0].length;
            if (n2 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            for (int i = 1; i < n; ++i) {
                if (dArray[i].length == n2) continue;
                throw new DimensionMismatchException(dArray[i].length, n2);
            }
            this.data = dArray;
        }
    }

    public Array2DRowRealMatrix(double[] dArray) {
        int n = dArray.length;
        this.data = new double[n][1];
        for (int i = 0; i < n; ++i) {
            this.data[i][0] = dArray[i];
        }
    }

    @Override
    public RealMatrix createMatrix(int n, int n2) throws NotStrictlyPositiveException {
        return new Array2DRowRealMatrix(n, n2);
    }

    @Override
    public RealMatrix copy() {
        return new Array2DRowRealMatrix(this.copyOut(), false);
    }

    public Array2DRowRealMatrix add(Array2DRowRealMatrix array2DRowRealMatrix) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, array2DRowRealMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = this.data[i];
            double[] dArray3 = array2DRowRealMatrix.data[i];
            double[] dArray4 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray2[j] + dArray3[j];
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    public Array2DRowRealMatrix subtract(Array2DRowRealMatrix array2DRowRealMatrix) throws MatrixDimensionMismatchException {
        MatrixUtils.checkSubtractionCompatible(this, array2DRowRealMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = this.data[i];
            double[] dArray3 = array2DRowRealMatrix.data[i];
            double[] dArray4 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray2[j] - dArray3[j];
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    public Array2DRowRealMatrix multiply(Array2DRowRealMatrix array2DRowRealMatrix) throws DimensionMismatchException {
        MatrixUtils.checkMultiplicationCompatible(this, array2DRowRealMatrix);
        int n = this.getRowDimension();
        int n2 = array2DRowRealMatrix.getColumnDimension();
        int n3 = this.getColumnDimension();
        double[][] dArray = new double[n][n2];
        double[] dArray2 = new double[n3];
        double[][] dArray3 = array2DRowRealMatrix.data;
        for (int i = 0; i < n2; ++i) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                dArray2[n4] = dArray3[n4][i];
            }
            for (n4 = 0; n4 < n; ++n4) {
                double[] dArray4 = this.data[n4];
                double d = 0.0;
                for (int j = 0; j < n3; ++j) {
                    d += dArray4[j] * dArray2[j];
                }
                dArray[n4][i] = d;
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    @Override
    public double[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(double[][] dArray, int n, int n2) throws NoDataException, OutOfRangeException, DimensionMismatchException, NullArgumentException {
        if (this.data == null) {
            if (n > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, n);
            }
            if (n2 > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, n2);
            }
            MathUtils.checkNotNull(dArray);
            int n3 = dArray.length;
            if (n3 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int n4 = dArray[0].length;
            if (n4 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            this.data = new double[dArray.length][n4];
            for (int i = 0; i < this.data.length; ++i) {
                if (dArray[i].length != n4) {
                    throw new DimensionMismatchException(dArray[i].length, n4);
                }
                System.arraycopy(dArray[i], 0, this.data[i + n], n2, n4);
            }
        } else {
            super.setSubMatrix(dArray, n, n2);
        }
    }

    @Override
    public double getEntry(int n, int n2) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        return this.data[n][n2];
    }

    @Override
    public void setEntry(int n, int n2, double d) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        this.data[n][n2] = d;
    }

    @Override
    public void addToEntry(int n, int n2, double d) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        double[] dArray = this.data[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    @Override
    public void multiplyEntry(int n, int n2, double d) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        double[] dArray = this.data[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] * d;
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public double[] operate(double[] dArray) throws DimensionMismatchException {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (dArray.length != n2) {
            throw new DimensionMismatchException(dArray.length, n2);
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = this.data[i];
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                d += dArray3[j] * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    @Override
    public double[] preMultiply(double[] dArray) throws DimensionMismatchException {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (dArray.length != n) {
            throw new DimensionMismatchException(dArray.length, n);
        }
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += this.data[j][i] * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    @Override
    public RealMatrix getSubMatrix(int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        double[][] dArray = new double[n5][n6];
        for (int i = 0; i < n5; ++i) {
            System.arraycopy(this.data[n + i], n3, dArray[i], 0, n6);
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix();
        array2DRowRealMatrix.data = dArray;
        return array2DRowRealMatrix;
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        realMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.data[i];
            for (int j = 0; j < n2; ++j) {
                dArray[j] = realMatrixChangingVisitor.visit(i, j, dArray[j]);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        realMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.data[i];
            for (int j = 0; j < n2; ++j) {
                realMatrixPreservingVisitor.visit(i, j, dArray[j]);
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n; i <= n2; ++i) {
            double[] dArray = this.data[i];
            for (int j = n3; j <= n4; ++j) {
                dArray[j] = realMatrixChangingVisitor.visit(i, j, dArray[j]);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n; i <= n2; ++i) {
            double[] dArray = this.data[i];
            for (int j = n3; j <= n4; ++j) {
                realMatrixPreservingVisitor.visit(i, j, dArray[j]);
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        realMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray = this.data[j];
                dArray[i] = realMatrixChangingVisitor.visit(j, i, dArray[i]);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        realMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                realMatrixPreservingVisitor.visit(j, i, this.data[j][i]);
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                double[] dArray = this.data[j];
                dArray[i] = realMatrixChangingVisitor.visit(j, i, dArray[i]);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                realMatrixPreservingVisitor.visit(j, i, this.data[j][i]);
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    private double[][] copyOut() {
        int n = this.getRowDimension();
        double[][] dArray = new double[n][this.getColumnDimension()];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.data[i], 0, dArray[i], 0, this.data[i].length);
        }
        return dArray;
    }

    private void copyIn(double[][] dArray) throws DimensionMismatchException, NoDataException, NullArgumentException {
        this.setSubMatrix(dArray, 0, 0);
    }

    @Override
    public double[] getRow(int n) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = this.getColumnDimension();
        double[] dArray = new double[n2];
        System.arraycopy(this.data[n], 0, dArray, 0, n2);
        return dArray;
    }

    @Override
    public void setRow(int n, double[] dArray) throws OutOfRangeException, MatrixDimensionMismatchException {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = this.getColumnDimension();
        if (dArray.length != n2) {
            throw new MatrixDimensionMismatchException(1, dArray.length, 1, n2);
        }
        System.arraycopy(dArray, 0, this.data[n], 0, n2);
    }
}

