/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.io.Serializable;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.linear.AbstractRealMatrix;
import org.apache.commons.math4.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.linear.ArrayRealVector;
import org.apache.commons.math4.linear.MatrixDimensionMismatchException;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.linear.SingularMatrixException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.numbers.core.Precision;

public class DiagonalMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = 20121229L;
    private final double[] data;

    public DiagonalMatrix(int n) throws NotStrictlyPositiveException {
        super(n, n);
        this.data = new double[n];
    }

    public DiagonalMatrix(double[] dArray) {
        this(dArray, true);
    }

    public DiagonalMatrix(double[] dArray, boolean bl) throws NullArgumentException {
        MathUtils.checkNotNull(dArray);
        this.data = bl ? (double[])dArray.clone() : dArray;
    }

    @Override
    public RealMatrix createMatrix(int n, int n2) throws NotStrictlyPositiveException, DimensionMismatchException {
        if (n != n2) {
            throw new DimensionMismatchException(n, n2);
        }
        return new DiagonalMatrix(n);
    }

    @Override
    public RealMatrix copy() {
        return new DiagonalMatrix(this.data);
    }

    public DiagonalMatrix add(DiagonalMatrix diagonalMatrix) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, diagonalMatrix);
        int n = this.getRowDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.data[i] + diagonalMatrix.data[i];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public DiagonalMatrix subtract(DiagonalMatrix diagonalMatrix) throws MatrixDimensionMismatchException {
        MatrixUtils.checkSubtractionCompatible(this, diagonalMatrix);
        int n = this.getRowDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.data[i] - diagonalMatrix.data[i];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public DiagonalMatrix multiply(DiagonalMatrix diagonalMatrix) throws DimensionMismatchException {
        MatrixUtils.checkMultiplicationCompatible(this, diagonalMatrix);
        int n = this.getRowDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.data[i] * diagonalMatrix.data[i];
        }
        return new DiagonalMatrix(dArray, false);
    }

    @Override
    public RealMatrix multiply(RealMatrix realMatrix) throws DimensionMismatchException {
        if (realMatrix instanceof DiagonalMatrix) {
            return this.multiply((DiagonalMatrix)realMatrix);
        }
        MatrixUtils.checkMultiplicationCompatible(this, realMatrix);
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.data[i] * realMatrix.getEntry(i, j);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    @Override
    public double[][] getData() {
        int n = this.getRowDimension();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = this.data[i];
        }
        return dArray;
    }

    public double[] getDataRef() {
        return this.data;
    }

    @Override
    public double getEntry(int n, int n2) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        return n == n2 ? this.data[n] : 0.0;
    }

    @Override
    public void setEntry(int n, int n2, double d) throws OutOfRangeException, NumberIsTooLargeException {
        if (n == n2) {
            MatrixUtils.checkRowIndex(this, n);
            this.data[n] = d;
        } else {
            this.ensureZero(d);
        }
    }

    @Override
    public void addToEntry(int n, int n2, double d) throws OutOfRangeException, NumberIsTooLargeException {
        if (n == n2) {
            MatrixUtils.checkRowIndex(this, n);
            int n3 = n;
            this.data[n3] = this.data[n3] + d;
        } else {
            this.ensureZero(d);
        }
    }

    @Override
    public void multiplyEntry(int n, int n2, double d) throws OutOfRangeException {
        if (n == n2) {
            MatrixUtils.checkRowIndex(this, n);
            int n3 = n;
            this.data[n3] = this.data[n3] * d;
        }
    }

    @Override
    public int getRowDimension() {
        return this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data.length;
    }

    @Override
    public double[] operate(double[] dArray) throws DimensionMismatchException {
        return this.multiply(new DiagonalMatrix(dArray, false)).getDataRef();
    }

    @Override
    public double[] preMultiply(double[] dArray) throws DimensionMismatchException {
        return this.operate(dArray);
    }

    @Override
    public RealVector preMultiply(RealVector realVector) throws DimensionMismatchException {
        double[] dArray = realVector instanceof ArrayRealVector ? ((ArrayRealVector)realVector).getDataRef() : realVector.toArray();
        return MatrixUtils.createRealVector(this.preMultiply(dArray));
    }

    private void ensureZero(double d) throws NumberIsTooLargeException {
        if (!Precision.equals(0.0, d, 1)) {
            throw new NumberIsTooLargeException(FastMath.abs(d), (Number)0, true);
        }
    }

    public DiagonalMatrix inverse() throws SingularMatrixException {
        return this.inverse(0.0);
    }

    public DiagonalMatrix inverse(double d) throws SingularMatrixException {
        if (this.isSingular(d)) {
            throw new SingularMatrixException();
        }
        double[] dArray = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            dArray[i] = 1.0 / this.data[i];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public boolean isSingular(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!Precision.equals(this.data[i], 0.0, d)) continue;
            return true;
        }
        return false;
    }
}

