/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.linear.ArrayRealVector;
import org.apache.commons.math4.linear.IterativeLinearSolver;
import org.apache.commons.math4.linear.NonSquareOperatorException;
import org.apache.commons.math4.linear.RealLinearOperator;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.util.IterationManager;
import org.apache.commons.math4.util.MathUtils;

public abstract class PreconditionedIterativeLinearSolver
extends IterativeLinearSolver {
    public PreconditionedIterativeLinearSolver(int n) {
        super(n);
    }

    public PreconditionedIterativeLinearSolver(IterationManager iterationManager) throws NullArgumentException {
        super(iterationManager);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException {
        MathUtils.checkNotNull(realVector2);
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, realVector2.copy());
    }

    @Override
    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        ((RealVector)arrayRealVector).set(0.0);
        return this.solveInPlace(realLinearOperator, null, realVector, arrayRealVector);
    }

    @Override
    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException {
        MathUtils.checkNotNull(realVector2);
        return this.solveInPlace(realLinearOperator, null, realVector, realVector2.copy());
    }

    protected static void checkParameters(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException {
        PreconditionedIterativeLinearSolver.checkParameters(realLinearOperator, realVector, realVector2);
        if (realLinearOperator2 != null) {
            if (realLinearOperator2.getColumnDimension() != realLinearOperator2.getRowDimension()) {
                throw new NonSquareOperatorException(realLinearOperator2.getColumnDimension(), realLinearOperator2.getRowDimension());
            }
            if (realLinearOperator2.getRowDimension() != realLinearOperator.getRowDimension()) {
                throw new DimensionMismatchException(realLinearOperator2.getRowDimension(), realLinearOperator.getRowDimension());
            }
        }
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, arrayRealVector);
    }

    public abstract RealVector solveInPlace(RealLinearOperator var1, RealLinearOperator var2, RealVector var3, RealVector var4) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException;

    @Override
    public RealVector solveInPlace(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException {
        return this.solveInPlace(realLinearOperator, null, realVector, realVector2);
    }
}

