/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.util.Arrays;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.ArrayRealVector;
import org.apache.commons.math4.linear.BlockRealMatrix;
import org.apache.commons.math4.linear.DecompositionSolver;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.linear.SingularMatrixException;
import org.apache.commons.math4.util.FastMath;

public class QRDecomposition {
    private double[][] qrt;
    private double[] rDiag;
    private RealMatrix cachedQ;
    private RealMatrix cachedQT;
    private RealMatrix cachedR;
    private RealMatrix cachedH;
    private final double threshold;

    public QRDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 0.0);
    }

    public QRDecomposition(RealMatrix realMatrix, double d) {
        this.threshold = d;
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        this.qrt = realMatrix.transpose().getData();
        this.rDiag = new double[FastMath.min(n, n2)];
        this.cachedQ = null;
        this.cachedQT = null;
        this.cachedR = null;
        this.cachedH = null;
        this.decompose(this.qrt);
    }

    protected void decompose(double[][] dArray) {
        for (int i = 0; i < FastMath.min(dArray.length, dArray[0].length); ++i) {
            this.performHouseholderReflection(i, dArray);
        }
    }

    protected void performHouseholderReflection(int n, double[][] dArray) {
        double d;
        double[] dArray2 = dArray[n];
        double d2 = 0.0;
        for (int i = n; i < dArray2.length; ++i) {
            double d3 = dArray2[i];
            d2 += d3 * d3;
        }
        this.rDiag[n] = d = dArray2[n] > 0.0 ? -FastMath.sqrt(d2) : FastMath.sqrt(d2);
        if (d != 0.0) {
            int n2 = n;
            dArray2[n2] = dArray2[n2] - d;
            for (int i = n + 1; i < dArray.length; ++i) {
                int n3;
                double[] dArray3 = dArray[i];
                double d4 = 0.0;
                for (n3 = n; n3 < dArray3.length; ++n3) {
                    d4 -= dArray3[n3] * dArray2[n3];
                }
                d4 /= d * dArray2[n];
                for (n3 = n; n3 < dArray3.length; ++n3) {
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] - d4 * dArray2[n3];
                }
            }
        }
    }

    public RealMatrix getR() {
        if (this.cachedR == null) {
            int n = this.qrt.length;
            int n2 = this.qrt[0].length;
            double[][] dArray = new double[n2][n];
            for (int i = FastMath.min(n2, n) - 1; i >= 0; --i) {
                dArray[i][i] = this.rDiag[i];
                for (int j = i + 1; j < n; ++j) {
                    dArray[i][j] = this.qrt[j][i];
                }
            }
            this.cachedR = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedR;
    }

    public RealMatrix getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public RealMatrix getQT() {
        if (this.cachedQT == null) {
            int n;
            int n2 = this.qrt.length;
            int n3 = this.qrt[0].length;
            double[][] dArray = new double[n3][n3];
            for (n = n3 - 1; n >= FastMath.min(n3, n2); --n) {
                dArray[n][n] = 1.0;
            }
            for (n = FastMath.min(n3, n2) - 1; n >= 0; --n) {
                double[] dArray2 = this.qrt[n];
                dArray[n][n] = 1.0;
                if (dArray2[n] == 0.0) continue;
                for (int i = n; i < n3; ++i) {
                    int n4;
                    double d = 0.0;
                    for (n4 = n; n4 < n3; ++n4) {
                        d -= dArray[i][n4] * dArray2[n4];
                    }
                    d /= this.rDiag[n] * dArray2[n];
                    for (n4 = n; n4 < n3; ++n4) {
                        double[] dArray3 = dArray[i];
                        int n5 = n4;
                        dArray3[n5] = dArray3[n5] + -d * dArray2[n4];
                    }
                }
            }
            this.cachedQT = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedQT;
    }

    public RealMatrix getH() {
        if (this.cachedH == null) {
            int n = this.qrt.length;
            int n2 = this.qrt[0].length;
            double[][] dArray = new double[n2][n];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < FastMath.min(i + 1, n); ++j) {
                    dArray[i][j] = this.qrt[j][i] / -this.rDiag[j];
                }
            }
            this.cachedH = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedH;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.qrt, this.rDiag, this.threshold);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] qrt;
        private final double[] rDiag;
        private final double threshold;

        private Solver(double[][] dArray, double[] dArray2, double d) {
            this.qrt = dArray;
            this.rDiag = dArray2;
            this.threshold = d;
        }

        @Override
        public boolean isNonSingular() {
            return !Solver.checkSingular(this.rDiag, this.threshold, false);
        }

        @Override
        public RealVector solve(RealVector realVector) {
            int n;
            int n2;
            int n3 = this.qrt.length;
            int n4 = this.qrt[0].length;
            if (realVector.getDimension() != n4) {
                throw new DimensionMismatchException(realVector.getDimension(), n4);
            }
            Solver.checkSingular(this.rDiag, this.threshold, true);
            double[] dArray = new double[n3];
            double[] dArray2 = realVector.toArray();
            for (n2 = 0; n2 < FastMath.min(n4, n3); ++n2) {
                double[] dArray3 = this.qrt[n2];
                double d = 0.0;
                for (n = n2; n < n4; ++n) {
                    d += dArray2[n] * dArray3[n];
                }
                d /= this.rDiag[n2] * dArray3[n2];
                for (n = n2; n < n4; ++n) {
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] + d * dArray3[n];
                }
            }
            for (n2 = this.rDiag.length - 1; n2 >= 0; --n2) {
                int n6 = n2;
                dArray2[n6] = dArray2[n6] / this.rDiag[n2];
                double d = dArray2[n2];
                double[] dArray4 = this.qrt[n2];
                dArray[n2] = d;
                for (n = 0; n < n2; ++n) {
                    int n7 = n;
                    dArray2[n7] = dArray2[n7] - d * dArray4[n];
                }
            }
            return new ArrayRealVector(dArray, false);
        }

        @Override
        public RealMatrix solve(RealMatrix realMatrix) {
            int n = this.qrt.length;
            int n2 = this.qrt[0].length;
            if (realMatrix.getRowDimension() != n2) {
                throw new DimensionMismatchException(realMatrix.getRowDimension(), n2);
            }
            Solver.checkSingular(this.rDiag, this.threshold, true);
            int n3 = realMatrix.getColumnDimension();
            int n4 = (n3 + 52 - 1) / 52;
            double[][] dArray = BlockRealMatrix.createBlocksLayout(n, n3);
            double[][] dArray2 = new double[realMatrix.getRowDimension()][52];
            double[] dArray3 = new double[52];
            for (int i = 0; i < n4; ++i) {
                int n5;
                int n6 = i * 52;
                int n7 = FastMath.min(n6 + 52, n3);
                int n8 = n7 - n6;
                realMatrix.copySubMatrix(0, n2 - 1, n6, n7 - 1, dArray2);
                for (n5 = 0; n5 < FastMath.min(n2, n); ++n5) {
                    int n9;
                    double[] dArray4;
                    double d;
                    int n10;
                    double[] dArray5 = this.qrt[n5];
                    double d2 = 1.0 / (this.rDiag[n5] * dArray5[n5]);
                    Arrays.fill(dArray3, 0, n8, 0.0);
                    for (n10 = n5; n10 < n2; ++n10) {
                        d = dArray5[n10];
                        dArray4 = dArray2[n10];
                        for (n9 = 0; n9 < n8; ++n9) {
                            int n11 = n9;
                            dArray3[n11] = dArray3[n11] + d * dArray4[n9];
                        }
                    }
                    n10 = 0;
                    while (n10 < n8) {
                        int n12 = n10++;
                        dArray3[n12] = dArray3[n12] * d2;
                    }
                    for (n10 = n5; n10 < n2; ++n10) {
                        d = dArray5[n10];
                        dArray4 = dArray2[n10];
                        for (n9 = 0; n9 < n8; ++n9) {
                            int n13 = n9;
                            dArray4[n13] = dArray4[n13] + dArray3[n9] * d;
                        }
                    }
                }
                for (n5 = this.rDiag.length - 1; n5 >= 0; --n5) {
                    int n14 = n5 / 52;
                    int n15 = n14 * 52;
                    double d = 1.0 / this.rDiag[n5];
                    double[] dArray6 = dArray2[n5];
                    double[] dArray7 = dArray[n14 * n4 + i];
                    int n16 = (n5 - n15) * n8;
                    for (int j = 0; j < n8; ++j) {
                        int n17 = j;
                        dArray6[n17] = dArray6[n17] * d;
                        dArray7[n16++] = dArray6[j];
                    }
                    double[] dArray8 = this.qrt[n5];
                    for (int j = 0; j < n5; ++j) {
                        double d3 = dArray8[j];
                        double[] dArray9 = dArray2[j];
                        for (int k = 0; k < n8; ++k) {
                            int n18 = k;
                            dArray9[n18] = dArray9[n18] - dArray6[k] * d3;
                        }
                    }
                }
            }
            return new BlockRealMatrix(n, n3, dArray, false);
        }

        @Override
        public RealMatrix getInverse() {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.qrt[0].length));
        }

        private static boolean checkSingular(double[] dArray, double d, boolean bl) {
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double d2 = dArray[i];
                if (!(FastMath.abs(d2) <= d)) continue;
                if (bl) {
                    SingularMatrixException singularMatrixException = new SingularMatrixException();
                    singularMatrixException.getContext().addMessage(LocalizedFormats.NUMBER_TOO_SMALL, d2, d);
                    singularMatrixException.getContext().addMessage(LocalizedFormats.INDEX, i);
                    throw singularMatrixException;
                }
                return true;
            }
            return false;
        }
    }
}

