/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.numbers.core.ArithmeticUtils;
import org.apache.commons.numbers.fraction.FractionException;

public class BigFraction
extends Number
implements Comparable<BigFraction>,
Serializable {
    public static final BigFraction TWO = new BigFraction(2);
    public static final BigFraction ONE = new BigFraction(1);
    public static final BigFraction ZERO = new BigFraction(0);
    public static final BigFraction MINUS_ONE = new BigFraction(-1);
    public static final BigFraction FOUR_FIFTHS = new BigFraction(4, 5);
    public static final BigFraction ONE_FIFTH = new BigFraction(1, 5);
    public static final BigFraction ONE_HALF = new BigFraction(1, 2);
    public static final BigFraction ONE_QUARTER = new BigFraction(1, 4);
    public static final BigFraction ONE_THIRD = new BigFraction(1, 3);
    public static final BigFraction THREE_FIFTHS = new BigFraction(3, 5);
    public static final BigFraction THREE_QUARTERS = new BigFraction(3, 4);
    public static final BigFraction TWO_FIFTHS = new BigFraction(2, 5);
    public static final BigFraction TWO_QUARTERS = new BigFraction(2, 4);
    public static final BigFraction TWO_THIRDS = new BigFraction(2, 3);
    private static final long serialVersionUID = -5630213147331578515L;
    private static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    private static final String PARAM_NAME_FRACTION = "fraction";
    private static final String PARAM_NAME_BG = "bg";
    private final BigInteger numerator;
    private final BigInteger denominator;

    public BigFraction(BigInteger bigInteger) {
        this(bigInteger, BigInteger.ONE);
    }

    public BigFraction(BigInteger bigInteger, BigInteger bigInteger2) {
        BigFraction.checkNotNull(bigInteger, "numerator");
        BigFraction.checkNotNull(bigInteger2, "denominator");
        if (bigInteger2.signum() == 0) {
            throw new FractionException("denominator must be different from 0", new Object[0]);
        }
        if (bigInteger.signum() == 0) {
            this.numerator = BigInteger.ZERO;
            this.denominator = BigInteger.ONE;
        } else {
            BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
            if (BigInteger.ONE.compareTo(bigInteger3) < 0) {
                bigInteger = bigInteger.divide(bigInteger3);
                bigInteger2 = bigInteger2.divide(bigInteger3);
            }
            if (bigInteger2.signum() == -1) {
                bigInteger = bigInteger.negate();
                bigInteger2 = bigInteger2.negate();
            }
            this.numerator = bigInteger;
            this.denominator = bigInteger2;
        }
    }

    public BigFraction(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("cannot convert NaN value");
        }
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("cannot convert infinite value");
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l & Long.MIN_VALUE;
        long l3 = l & 0x7FF0000000000000L;
        long l4 = l & 0xFFFFFFFFFFFFFL;
        if (l3 != 0L) {
            l4 |= 0x10000000000000L;
        }
        if (l2 != 0L) {
            l4 = -l4;
        }
        int n = (int)(l3 >> 52) - 1075;
        while ((l4 & 0x1FFFFFFFFFFFFEL) != 0L && (l4 & 1L) == 0L) {
            l4 >>= 1;
            ++n;
        }
        if (n < 0) {
            this.numerator = BigInteger.valueOf(l4);
            this.denominator = BigInteger.ZERO.flipBit(-n);
        } else {
            this.numerator = BigInteger.valueOf(l4).multiply(BigInteger.ZERO.flipBit(n));
            this.denominator = BigInteger.ONE;
        }
    }

    public BigFraction(double d, double d2, int n) {
        this(d, d2, Integer.MAX_VALUE, n);
    }

    private BigFraction(double d, double d2, int n, int n2) {
        long l = Integer.MAX_VALUE;
        double d3 = d;
        long l2 = (long)Math.floor(d3);
        if (Math.abs(l2) > l) {
            throw new FractionException("Overflow trying to convert {0} to fraction ({1}/{2})", d, l2, 1L);
        }
        if (Math.abs((double)l2 - d) < d2) {
            this.numerator = BigInteger.valueOf(l2);
            this.denominator = BigInteger.ONE;
            return;
        }
        long l3 = 1L;
        long l4 = 0L;
        long l5 = l2;
        long l6 = 1L;
        long l7 = 0L;
        long l8 = 1L;
        int n3 = 0;
        boolean bl = false;
        do {
            ++n3;
            double d4 = 1.0 / (d3 - (double)l2);
            long l9 = (long)Math.floor(d4);
            l7 = l9 * l5 + l3;
            l8 = l9 * l6 + l4;
            if (l7 > l || l8 > l) {
                if (d2 == 0.0 && Math.abs(l6) < (long)n) break;
                throw new FractionException("Overflow trying to convert {0} to fraction ({1}/{2})", d, l7, l8);
            }
            double d5 = (double)l7 / (double)l8;
            if (n3 < n2 && Math.abs(d5 - d) > d2 && l8 < (long)n) {
                l3 = l5;
                l5 = l7;
                l4 = l6;
                l6 = l8;
                l2 = l9;
                d3 = d4;
                continue;
            }
            bl = true;
        } while (!bl);
        if (n3 >= n2) {
            throw new FractionException("Unable to convert {0} to fraction after {1} iterations", d, n2);
        }
        if (l8 < (long)n) {
            this.numerator = BigInteger.valueOf(l7);
            this.denominator = BigInteger.valueOf(l8);
        } else {
            this.numerator = BigInteger.valueOf(l5);
            this.denominator = BigInteger.valueOf(l6);
        }
    }

    public BigFraction(double d, int n) {
        this(d, 0.0, n, 100);
    }

    public BigFraction(int n) {
        this(BigInteger.valueOf(n), BigInteger.ONE);
    }

    public BigFraction(int n, int n2) {
        this(BigInteger.valueOf(n), BigInteger.valueOf(n2));
    }

    public BigFraction(long l) {
        this(BigInteger.valueOf(l), BigInteger.ONE);
    }

    public BigFraction(long l, long l2) {
        this(BigInteger.valueOf(l), BigInteger.valueOf(l2));
    }

    public static BigFraction getReducedFraction(int n, int n2) {
        if (n == 0) {
            return ZERO;
        }
        return new BigFraction(n, n2);
    }

    public BigFraction abs() {
        return this.numerator.signum() == 1 ? this : this.negate();
    }

    public BigFraction add(BigInteger bigInteger) {
        BigFraction.checkNotNull(bigInteger, PARAM_NAME_BG);
        if (this.numerator.signum() == 0) {
            return new BigFraction(bigInteger);
        }
        if (bigInteger.signum() == 0) {
            return this;
        }
        return new BigFraction(this.numerator.add(this.denominator.multiply(bigInteger)), this.denominator);
    }

    public BigFraction add(int n) {
        return this.add(BigInteger.valueOf(n));
    }

    public BigFraction add(long l) {
        return this.add(BigInteger.valueOf(l));
    }

    public BigFraction add(BigFraction bigFraction) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigFraction.checkNotNull(bigFraction, PARAM_NAME_FRACTION);
        if (bigFraction.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return bigFraction;
        }
        if (this.denominator.equals(bigFraction.denominator)) {
            bigInteger2 = this.numerator.add(bigFraction.numerator);
            bigInteger = this.denominator;
        } else {
            bigInteger2 = this.numerator.multiply(bigFraction.denominator).add(bigFraction.numerator.multiply(this.denominator));
            bigInteger = this.denominator.multiply(bigFraction.denominator);
        }
        if (bigInteger2.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(bigInteger2, bigInteger);
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator));
    }

    public BigDecimal bigDecimalValue(RoundingMode roundingMode) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), roundingMode);
    }

    public BigDecimal bigDecimalValue(int n, RoundingMode roundingMode) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), n, roundingMode);
    }

    @Override
    public int compareTo(BigFraction bigFraction) {
        int n;
        int n2 = this.numerator.signum();
        if (n2 != (n = bigFraction.numerator.signum())) {
            return n2 > n ? 1 : -1;
        }
        if (n2 == 0) {
            return 0;
        }
        BigInteger bigInteger = this.numerator.multiply(bigFraction.denominator);
        BigInteger bigInteger2 = this.denominator.multiply(bigFraction.numerator);
        return bigInteger.compareTo(bigInteger2);
    }

    public BigFraction divide(BigInteger bigInteger) {
        BigFraction.checkNotNull(bigInteger, PARAM_NAME_BG);
        if (bigInteger.signum() == 0) {
            throw new FractionException("denominator must be different from 0", new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator, this.denominator.multiply(bigInteger));
    }

    public BigFraction divide(int n) {
        return this.divide(BigInteger.valueOf(n));
    }

    public BigFraction divide(long l) {
        return this.divide(BigInteger.valueOf(l));
    }

    public BigFraction divide(BigFraction bigFraction) {
        BigFraction.checkNotNull(bigFraction, PARAM_NAME_FRACTION);
        if (bigFraction.numerator.signum() == 0) {
            throw new FractionException("denominator must be different from 0", new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(bigFraction.reciprocal());
    }

    @Override
    public double doubleValue() {
        double d = this.numerator.doubleValue();
        double d2 = this.denominator.doubleValue();
        double d3 = d / d2;
        if (Double.isInfinite(d) || Double.isInfinite(d2) || Double.isNaN(d3)) {
            int n = Math.max(this.numerator.bitLength(), this.denominator.bitLength()) - Math.getExponent(Double.MAX_VALUE);
            d3 = this.numerator.shiftRight(n).doubleValue() / this.denominator.shiftRight(n).doubleValue();
        }
        return d3;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof BigFraction) {
            BigFraction bigFraction = ((BigFraction)object).reduce();
            BigFraction bigFraction2 = this.reduce();
            bl = bigFraction2.numerator.equals(bigFraction.numerator) && bigFraction2.denominator.equals(bigFraction.denominator);
        }
        return bl;
    }

    @Override
    public float floatValue() {
        float f = this.numerator.floatValue();
        float f2 = this.denominator.floatValue();
        float f3 = f / f2;
        if (Float.isInfinite(f) || Float.isInfinite(f2) || Float.isNaN(f3)) {
            int n = Math.max(this.numerator.bitLength(), this.denominator.bitLength()) - Math.getExponent(Float.MAX_VALUE);
            f3 = this.numerator.shiftRight(n).floatValue() / this.denominator.shiftRight(n).floatValue();
        }
        return f3;
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public int getDenominatorAsInt() {
        return this.denominator.intValue();
    }

    public long getDenominatorAsLong() {
        return this.denominator.longValue();
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public int getNumeratorAsInt() {
        return this.numerator.intValue();
    }

    public long getNumeratorAsLong() {
        return this.numerator.longValue();
    }

    public int hashCode() {
        return 37 * (629 + this.numerator.hashCode()) + this.denominator.hashCode();
    }

    @Override
    public int intValue() {
        return this.numerator.divide(this.denominator).intValue();
    }

    @Override
    public long longValue() {
        return this.numerator.divide(this.denominator).longValue();
    }

    public BigFraction multiply(BigInteger bigInteger) {
        BigFraction.checkNotNull(bigInteger, PARAM_NAME_BG);
        if (this.numerator.signum() == 0 || bigInteger.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(bigInteger.multiply(this.numerator), this.denominator);
    }

    public BigFraction multiply(int n) {
        if (n == 0 || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(n));
    }

    public BigFraction multiply(long l) {
        if (l == 0L || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(l));
    }

    public BigFraction multiply(BigFraction bigFraction) {
        BigFraction.checkNotNull(bigFraction, PARAM_NAME_FRACTION);
        if (this.numerator.signum() == 0 || bigFraction.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator.multiply(bigFraction.numerator), this.denominator.multiply(bigFraction.denominator));
    }

    public BigFraction negate() {
        return new BigFraction(this.numerator.negate(), this.denominator);
    }

    public double percentageValue() {
        return this.multiply(ONE_HUNDRED).doubleValue();
    }

    public BigFraction pow(int n) {
        if (n == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (n < 0) {
            return new BigFraction(this.denominator.pow(-n), this.numerator.pow(-n));
        }
        return new BigFraction(this.numerator.pow(n), this.denominator.pow(n));
    }

    public BigFraction pow(long l) {
        if (l == 0L) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (l < 0L) {
            return new BigFraction(ArithmeticUtils.pow(this.denominator, -l), ArithmeticUtils.pow(this.numerator, -l));
        }
        return new BigFraction(ArithmeticUtils.pow(this.numerator, l), ArithmeticUtils.pow(this.denominator, l));
    }

    public BigFraction pow(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (bigInteger.signum() == -1) {
            BigInteger bigInteger2 = bigInteger.negate();
            return new BigFraction(ArithmeticUtils.pow(this.denominator, bigInteger2), ArithmeticUtils.pow(this.numerator, bigInteger2));
        }
        return new BigFraction(ArithmeticUtils.pow(this.numerator, bigInteger), ArithmeticUtils.pow(this.denominator, bigInteger));
    }

    public double pow(double d) {
        return Math.pow(this.numerator.doubleValue(), d) / Math.pow(this.denominator.doubleValue(), d);
    }

    public BigFraction reciprocal() {
        return new BigFraction(this.denominator, this.numerator);
    }

    public BigFraction reduce() {
        BigInteger bigInteger = this.numerator.gcd(this.denominator);
        if (BigInteger.ONE.compareTo(bigInteger) < 0) {
            return new BigFraction(this.numerator.divide(bigInteger), this.denominator.divide(bigInteger));
        }
        return this;
    }

    public BigFraction subtract(BigInteger bigInteger) {
        BigFraction.checkNotNull(bigInteger, PARAM_NAME_BG);
        if (bigInteger.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return new BigFraction(bigInteger.negate());
        }
        return new BigFraction(this.numerator.subtract(this.denominator.multiply(bigInteger)), this.denominator);
    }

    public BigFraction subtract(int n) {
        return this.subtract(BigInteger.valueOf(n));
    }

    public BigFraction subtract(long l) {
        return this.subtract(BigInteger.valueOf(l));
    }

    public BigFraction subtract(BigFraction bigFraction) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigFraction.checkNotNull(bigFraction, PARAM_NAME_FRACTION);
        if (bigFraction.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return bigFraction.negate();
        }
        if (this.denominator.equals(bigFraction.denominator)) {
            bigInteger2 = this.numerator.subtract(bigFraction.numerator);
            bigInteger = this.denominator;
        } else {
            bigInteger2 = this.numerator.multiply(bigFraction.denominator).subtract(bigFraction.numerator.multiply(this.denominator));
            bigInteger = this.denominator.multiply(bigFraction.denominator);
        }
        return new BigFraction(bigInteger2, bigInteger);
    }

    public String toString() {
        Object object = BigInteger.ONE.equals(this.denominator) ? this.numerator.toString() : (BigInteger.ZERO.equals(this.numerator) ? "0" : this.numerator + " / " + this.denominator);
        return object;
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }
}

