/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.fraction.ContinuedFraction;
import org.apache.commons.numbers.gamma.LogBeta;

public class RegularizedBeta {
    private static final double DEFAULT_EPSILON = 1.0E-14;

    public static double value(double d, double d2, double d3) {
        return RegularizedBeta.value(d, d2, d3, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double value(double d, final double d2, final double d3, double d4, int n) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || d < 0.0 || d > 1.0 || d2 <= 0.0 || d3 <= 0.0) {
            return Double.NaN;
        }
        if (d > (d2 + 1.0) / (2.0 + d3 + d2) && 1.0 - d <= (d3 + 1.0) / (2.0 + d3 + d2)) {
            return 1.0 - RegularizedBeta.value(1.0 - d, d3, d2, d4, n);
        }
        ContinuedFraction continuedFraction = new ContinuedFraction(){

            @Override
            protected double getB(int n, double d) {
                if (n % 2 == 0) {
                    double d22 = (double)n / 2.0;
                    return d22 * (d3 - d22) * d / ((d2 + 2.0 * d22 - 1.0) * (d2 + 2.0 * d22));
                }
                double d32 = ((double)n - 1.0) / 2.0;
                return -((d2 + d32) * (d2 + d3 + d32) * d) / ((d2 + 2.0 * d32) * (d2 + 2.0 * d32 + 1.0));
            }

            @Override
            protected double getA(int n, double d) {
                return 1.0;
            }
        };
        return Math.exp(d2 * Math.log(d) + d3 * Math.log1p(-d) - Math.log(d2) - LogBeta.value(d2, d3)) / continuedFraction.evaluate(d, d4, n);
    }
}

