/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core;

import org.apache.commons.rng.RandomProviderState;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.RandomProviderDefaultState;

public abstract class BaseProvider
implements RestorableUniformRandomProvider {
    @Override
    public int nextInt(int n) {
        int n2;
        int n3;
        this.checkStrictlyPositive(n);
        if ((n & -n) == n) {
            return (int)((long)n * (long)(this.nextInt() >>> 1) >> 31);
        }
        while ((n3 = this.nextInt() >>> 1) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    @Override
    public long nextLong(long l) {
        long l2;
        long l3;
        this.checkStrictlyPositive(l);
        while ((l3 = this.nextLong() >>> 1) - (l2 = l3 % l) + (l - 1L) < 0L) {
        }
        return l2;
    }

    @Override
    public RandomProviderState saveState() {
        return new RandomProviderDefaultState(this.getStateInternal());
    }

    @Override
    public void restoreState(RandomProviderState randomProviderState) {
        if (!(randomProviderState instanceof RandomProviderDefaultState)) {
            throw new IllegalArgumentException("Foreign instance");
        }
        this.setStateInternal(((RandomProviderDefaultState)randomProviderState).getState());
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected byte[] composeStateInternal(byte[] byArray, byte[] byArray2) {
        int n = byArray2.length + byArray.length;
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    protected byte[][] splitStateInternal(byte[] byArray, int n) {
        this.checkStateSize(byArray, n);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        int n2 = byArray.length - n;
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n, byArray3, 0, n2);
        return new byte[][]{byArray2, byArray3};
    }

    protected byte[] getStateInternal() {
        return new byte[0];
    }

    protected void setStateInternal(byte[] byArray) {
        if (byArray.length != 0) {
            throw new IllegalStateException("State not fully recovered by subclasses");
        }
    }

    protected void fillState(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        System.arraycopy(nArray2, 0, nArray, 0, Math.min(n2, n));
        if (n2 < n) {
            for (int i = n2; i < n; ++i) {
                nArray[i] = (int)(BaseProvider.scrambleWell(nArray[i - nArray2.length], i) & 0xFFFFFFFFL);
            }
        }
    }

    protected void fillState(long[] lArray, long[] lArray2) {
        int n = lArray.length;
        int n2 = lArray2.length;
        System.arraycopy(lArray2, 0, lArray, 0, Math.min(n2, n));
        if (n2 < n) {
            for (int i = n2; i < n; ++i) {
                lArray[i] = BaseProvider.scrambleWell(lArray[i - lArray2.length], i);
            }
        }
    }

    @Deprecated
    protected void checkStateSize(byte[] byArray, int n) {
        if (byArray.length < n) {
            throw new IllegalStateException("State size must be larger than " + n + " but was " + byArray.length);
        }
    }

    protected void checkIndex(int n, int n2, int n3) {
        if (n3 < n || n3 > n2) {
            throw new IndexOutOfBoundsException(n3 + " is out of interval [" + n + ", " + n2 + "]");
        }
    }

    private void checkStrictlyPositive(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Must be strictly positive: " + l);
        }
    }

    private static long scramble(long l, long l2, int n, int n2) {
        return l2 * (l ^ l >> n) + (long)n2;
    }

    private static long scrambleWell(long l, int n) {
        return BaseProvider.scramble(l, 1812433253L, 30, n);
    }
}

