/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class DiscreteUniformSampler
extends SamplerBase
implements DiscreteSampler {
    private final DiscreteSampler delegate;

    public DiscreteUniformSampler(UniformRandomProvider uniformRandomProvider, int n, int n2) {
        super(null);
        if (n > n2) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        int n3 = n2 - n + 1;
        this.delegate = n3 <= 0 ? new LargeRangeDiscreteUniformSampler(uniformRandomProvider, n, n2) : new SmallRangeDiscreteUniformSampler(uniformRandomProvider, n, n3);
    }

    @Override
    public int sample() {
        return this.delegate.sample();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private static class LargeRangeDiscreteUniformSampler
    extends AbstractDiscreteUniformSampler {
        private final int upper;

        LargeRangeDiscreteUniformSampler(UniformRandomProvider uniformRandomProvider, int n, int n2) {
            super(uniformRandomProvider, n);
            this.upper = n2;
        }

        @Override
        public int sample() {
            int n;
            while ((n = this.rng.nextInt()) < this.lower || n > this.upper) {
            }
            return n;
        }
    }

    private static class SmallRangeDiscreteUniformSampler
    extends AbstractDiscreteUniformSampler {
        private final int range;

        SmallRangeDiscreteUniformSampler(UniformRandomProvider uniformRandomProvider, int n, int n2) {
            super(uniformRandomProvider, n);
            this.range = n2;
        }

        @Override
        public int sample() {
            return this.lower + this.rng.nextInt(this.range);
        }
    }

    private static abstract class AbstractDiscreteUniformSampler
    implements DiscreteSampler {
        protected final UniformRandomProvider rng;
        protected final int lower;

        AbstractDiscreteUniformSampler(UniformRandomProvider uniformRandomProvider, int n) {
            this.rng = uniformRandomProvider;
            this.lower = n;
        }

        public String toString() {
            return "Uniform deviate [" + this.rng.toString() + "]";
        }
    }
}

