/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple;

import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.internal.ProviderBuilder;
import org.apache.commons.rng.simple.internal.SeedFactory;

public enum RandomSource {
    JDK(ProviderBuilder.RandomSourceInternal.JDK),
    WELL_512_A(ProviderBuilder.RandomSourceInternal.WELL_512_A),
    WELL_1024_A(ProviderBuilder.RandomSourceInternal.WELL_1024_A),
    WELL_19937_A(ProviderBuilder.RandomSourceInternal.WELL_19937_A),
    WELL_19937_C(ProviderBuilder.RandomSourceInternal.WELL_19937_C),
    WELL_44497_A(ProviderBuilder.RandomSourceInternal.WELL_44497_A),
    WELL_44497_B(ProviderBuilder.RandomSourceInternal.WELL_44497_B),
    MT(ProviderBuilder.RandomSourceInternal.MT),
    ISAAC(ProviderBuilder.RandomSourceInternal.ISAAC),
    SPLIT_MIX_64(ProviderBuilder.RandomSourceInternal.SPLIT_MIX_64),
    XOR_SHIFT_1024_S(ProviderBuilder.RandomSourceInternal.XOR_SHIFT_1024_S),
    TWO_CMRES(ProviderBuilder.RandomSourceInternal.TWO_CMRES),
    TWO_CMRES_SELECT(ProviderBuilder.RandomSourceInternal.TWO_CMRES_SELECT),
    MT_64(ProviderBuilder.RandomSourceInternal.MT_64),
    MWC_256(ProviderBuilder.RandomSourceInternal.MWC_256),
    KISS(ProviderBuilder.RandomSourceInternal.KISS),
    XOR_SHIFT_1024_S_PHI(ProviderBuilder.RandomSourceInternal.XOR_SHIFT_1024_S_PHI),
    XO_RO_SHI_RO_64_S(ProviderBuilder.RandomSourceInternal.XO_RO_SHI_RO_64_S),
    XO_RO_SHI_RO_64_SS(ProviderBuilder.RandomSourceInternal.XO_RO_SHI_RO_64_SS),
    XO_SHI_RO_128_PLUS(ProviderBuilder.RandomSourceInternal.XO_SHI_RO_128_PLUS),
    XO_SHI_RO_128_SS(ProviderBuilder.RandomSourceInternal.XO_SHI_RO_128_SS),
    XO_RO_SHI_RO_128_PLUS(ProviderBuilder.RandomSourceInternal.XO_RO_SHI_RO_128_PLUS),
    XO_RO_SHI_RO_128_SS(ProviderBuilder.RandomSourceInternal.XO_RO_SHI_RO_128_SS),
    XO_SHI_RO_256_PLUS(ProviderBuilder.RandomSourceInternal.XO_SHI_RO_256_PLUS),
    XO_SHI_RO_256_SS(ProviderBuilder.RandomSourceInternal.XO_SHI_RO_256_SS),
    XO_SHI_RO_512_PLUS(ProviderBuilder.RandomSourceInternal.XO_SHI_RO_512_PLUS),
    XO_SHI_RO_512_SS(ProviderBuilder.RandomSourceInternal.XO_SHI_RO_512_SS);

    private final ProviderBuilder.RandomSourceInternal internalIdentifier;

    private RandomSource(ProviderBuilder.RandomSourceInternal randomSourceInternal) {
        this.internalIdentifier = randomSourceInternal;
    }

    ProviderBuilder.RandomSourceInternal getInternalIdentifier() {
        return this.internalIdentifier;
    }

    public boolean isNativeSeed(Object object) {
        return this.internalIdentifier.isNativeSeed(object);
    }

    public static RestorableUniformRandomProvider create(RandomSource randomSource) {
        return RandomSource.create(randomSource, null, new Object[0]);
    }

    public static RestorableUniformRandomProvider create(RandomSource randomSource, Object object, Object ... objectArray) {
        return ProviderBuilder.create(randomSource.getInternalIdentifier(), object, objectArray);
    }

    public static int createInt() {
        return SeedFactory.createInt();
    }

    public static long createLong() {
        return SeedFactory.createLong();
    }

    public static int[] createIntArray(int n) {
        return SeedFactory.createIntArray(n);
    }

    public static long[] createLongArray(int n) {
        return SeedFactory.createLongArray(n);
    }

    public static UniformRandomProvider unrestorable(final UniformRandomProvider uniformRandomProvider) {
        return new UniformRandomProvider(){

            @Override
            public void nextBytes(byte[] byArray) {
                uniformRandomProvider.nextBytes(byArray);
            }

            @Override
            public void nextBytes(byte[] byArray, int n, int n2) {
                uniformRandomProvider.nextBytes(byArray, n, n2);
            }

            @Override
            public int nextInt() {
                return uniformRandomProvider.nextInt();
            }

            @Override
            public int nextInt(int n) {
                return uniformRandomProvider.nextInt(n);
            }

            @Override
            public long nextLong() {
                return uniformRandomProvider.nextLong();
            }

            @Override
            public long nextLong(long l) {
                return uniformRandomProvider.nextLong(l);
            }

            @Override
            public boolean nextBoolean() {
                return uniformRandomProvider.nextBoolean();
            }

            @Override
            public float nextFloat() {
                return uniformRandomProvider.nextFloat();
            }

            @Override
            public double nextDouble() {
                return uniformRandomProvider.nextDouble();
            }

            public String toString() {
                return uniformRandomProvider.toString();
            }
        };
    }
}

