/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.common;

import io.virtdata.core.murmur.Murmur3F;
import java.nio.ByteBuffer;
import java.util.function.LongUnaryOperator;

public class ThreadSafeHash
implements LongUnaryOperator {
    private static ThreadLocal<HashState> tlstate = ThreadLocal.withInitial(HashState::new);

    @Override
    public long applyAsLong(long l) {
        HashState hashState = tlstate.get();
        hashState.murmur3F.reset();
        hashState.byteBuffer.putLong(0, l);
        hashState.murmur3F.update(hashState.byteBuffer.array(), 0, 8);
        long l2 = Math.abs(hashState.murmur3F.getValue());
        return l2;
    }

    private static class HashState {
        public Murmur3F murmur3F = new Murmur3F();
        public ByteBuffer byteBuffer = ByteBuffer.allocate(8);
    }
}

