/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.correlation;

import io.virtdata.shaded.oac.statistics.correlation.PearsonsCorrelation;
import io.virtdata.shaded.oac.statistics.ranking.NaNStrategy;
import io.virtdata.shaded.oac.statistics.ranking.NaturalRanking;
import io.virtdata.shaded.oac.statistics.ranking.RankingAlgorithm;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.BlockRealMatrix;
import org.apache.commons.math4.linear.RealMatrix;

public class SpearmansCorrelation {
    private final RealMatrix data;
    private final RankingAlgorithm rankingAlgorithm;
    private final PearsonsCorrelation rankCorrelation;

    public SpearmansCorrelation() {
        this(new NaturalRanking());
    }

    public SpearmansCorrelation(RankingAlgorithm rankingAlgorithm) throws MathIllegalArgumentException {
        if (rankingAlgorithm instanceof NaturalRanking && NaNStrategy.REMOVED == ((NaturalRanking)rankingAlgorithm).getNanStrategy()) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_SUPPORTED_NAN_STRATEGY, new Object[]{NaNStrategy.REMOVED});
        }
        this.data = null;
        this.rankingAlgorithm = rankingAlgorithm;
        this.rankCorrelation = null;
    }

    public SpearmansCorrelation(RealMatrix realMatrix) {
        this(realMatrix, new NaturalRanking());
    }

    public SpearmansCorrelation(RealMatrix realMatrix, RankingAlgorithm rankingAlgorithm) throws MathIllegalArgumentException {
        if (rankingAlgorithm instanceof NaturalRanking && NaNStrategy.REMOVED == ((NaturalRanking)rankingAlgorithm).getNanStrategy()) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_SUPPORTED_NAN_STRATEGY, new Object[]{NaNStrategy.REMOVED});
        }
        this.rankingAlgorithm = rankingAlgorithm;
        this.data = this.rankTransform(realMatrix);
        this.rankCorrelation = new PearsonsCorrelation(this.data);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.rankCorrelation.getCorrelationMatrix();
    }

    public PearsonsCorrelation getRankCorrelation() {
        return this.rankCorrelation;
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix realMatrix) {
        RealMatrix realMatrix2 = this.rankTransform(realMatrix);
        return new PearsonsCorrelation().computeCorrelationMatrix(realMatrix2);
    }

    public RealMatrix computeCorrelationMatrix(double[][] dArray) {
        return this.computeCorrelationMatrix(new BlockRealMatrix(dArray));
    }

    public double correlation(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, dArray.length, 2);
        }
        return new PearsonsCorrelation().correlation(this.rankingAlgorithm.rank(dArray), this.rankingAlgorithm.rank(dArray2));
    }

    private RealMatrix rankTransform(RealMatrix realMatrix) {
        RealMatrix realMatrix2 = realMatrix.copy();
        for (int i = 0; i < realMatrix2.getColumnDimension(); ++i) {
            realMatrix2.setColumn(i, this.rankingAlgorithm.rank(realMatrix2.getColumn(i)));
        }
        return realMatrix2;
    }
}

