/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.Erf;
import org.apache.commons.numbers.gamma.ErfDifference;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.LogNormalSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class LogNormalDistribution
extends AbstractContinuousDistribution {
    private static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    private static final double SQRT2 = Math.sqrt(2.0);
    private final double scale;
    private final double shape;
    private final double logShapePlusHalfLog2Pi;

    public LogNormalDistribution(double d, double d2) {
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.scale = d;
        this.shape = d2;
        this.logShapePlusHalfLog2Pi = Math.log(d2) + 0.5 * Math.log(Math.PI * 2);
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double density(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = Math.log(d) - this.scale;
        double d3 = d2 / this.shape;
        return Math.exp(-0.5 * d3 * d3) / (this.shape * SQRT2PI * d);
    }

    @Override
    public double logDensity(double d) {
        if (d <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = Math.log(d);
        double d3 = d2 - this.scale;
        double d4 = d3 / this.shape;
        return -0.5 * d4 * d4 - (this.logShapePlusHalfLog2Pi + d2);
    }

    @Override
    public double cumulativeProbability(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = Math.log(d) - this.scale;
        if (Math.abs(d2) > 40.0 * this.shape) {
            return d2 < 0.0 ? 0.0 : 1.0;
        }
        return 0.5 + 0.5 * Erf.value(d2 / (this.shape * SQRT2));
    }

    @Override
    public double probability(double d, double d2) {
        if (d > d2) {
            throw new DistributionException("{0} > {1}", d, d2);
        }
        if (d <= 0.0 || d2 <= 0.0) {
            return super.probability(d, d2);
        }
        double d3 = this.shape * SQRT2;
        double d4 = (Math.log(d) - this.scale) / d3;
        double d5 = (Math.log(d2) - this.scale) / d3;
        return 0.5 * ErfDifference.value(d4, d5);
    }

    @Override
    public double getMean() {
        double d = this.shape;
        return Math.exp(this.scale + d * d / 2.0);
    }

    @Override
    public double getVariance() {
        double d = this.shape;
        double d2 = d * d;
        return Math.expm1(d2) * Math.exp(2.0 * this.scale + d2);
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new LogNormalSampler(new ZigguratNormalizedGaussianSampler(uniformRandomProvider), LogNormalDistribution.this.scale, LogNormalDistribution.this.shape);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

