/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;

public class TriangularDistribution
extends AbstractContinuousDistribution {
    private static final long serialVersionUID = 20160311L;
    private final double a;
    private final double b;
    private final double c;

    public TriangularDistribution(double d, double d2, double d3) {
        if (d >= d3) {
            throw new DistributionException("{0} > {1}", d, d3);
        }
        if (d2 < d) {
            throw new DistributionException("{0} < {1}", d2, d);
        }
        if (d2 > d3) {
            throw new DistributionException("{0} > {1}", d2, d3);
        }
        this.a = d;
        this.c = d2;
        this.b = d3;
    }

    public double getMode() {
        return this.c;
    }

    @Override
    public double density(double d) {
        if (d < this.a) {
            return 0.0;
        }
        if (this.a <= d && d < this.c) {
            double d2 = 2.0 * (d - this.a);
            double d3 = (this.b - this.a) * (this.c - this.a);
            return d2 / d3;
        }
        if (d == this.c) {
            return 2.0 / (this.b - this.a);
        }
        if (this.c < d && d <= this.b) {
            double d4 = 2.0 * (this.b - d);
            double d5 = (this.b - this.a) * (this.b - this.c);
            return d4 / d5;
        }
        return 0.0;
    }

    @Override
    public double cumulativeProbability(double d) {
        if (d < this.a) {
            return 0.0;
        }
        if (this.a <= d && d < this.c) {
            double d2 = (d - this.a) * (d - this.a);
            double d3 = (this.b - this.a) * (this.c - this.a);
            return d2 / d3;
        }
        if (d == this.c) {
            return (this.c - this.a) / (this.b - this.a);
        }
        if (this.c < d && d <= this.b) {
            double d4 = (this.b - d) * (this.b - d);
            double d5 = (this.b - this.a) * (this.b - this.c);
            return 1.0 - d4 / d5;
        }
        return 1.0;
    }

    @Override
    public double getMean() {
        return (this.a + this.b + this.c) / 3.0;
    }

    @Override
    public double getVariance() {
        return (this.a * this.a + this.b * this.b + this.c * this.c - this.a * this.b - this.a * this.c - this.b * this.c) / 18.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.a;
    }

    @Override
    public double getSupportUpperBound() {
        return this.b;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        if (d == 0.0) {
            return this.a;
        }
        if (d == 1.0) {
            return this.b;
        }
        if (d < (this.c - this.a) / (this.b - this.a)) {
            return this.a + Math.sqrt(d * (this.b - this.a) * (this.c - this.a));
        }
        return this.b - Math.sqrt((1.0 - d) * (this.b - this.a) * (this.b - this.c));
    }
}

