/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.inference;

import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import java.util.Arrays;
import org.apache.commons.math4.Field;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.distribution.AbstractRealDistribution;
import org.apache.commons.math4.distribution.EnumeratedRealDistribution;
import org.apache.commons.math4.exception.InsufficientDataException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NotANumberException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.TooManyIterationsException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.fraction.BigFraction;
import org.apache.commons.math4.fraction.BigFractionField;
import org.apache.commons.math4.fraction.FractionConversionException;
import org.apache.commons.math4.linear.Array2DRowFieldMatrix;
import org.apache.commons.math4.linear.FieldMatrix;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.numbers.combinatorics.BinomialCoefficientDouble;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;

public class KolmogorovSmirnovTest {
    private static final int MAXIMUM_PARTIAL_SUM_COUNT = 100000;
    private static final double KS_SUM_CAUCHY_CRITERION = 1.0E-20;
    private static final double PG_SUM_RELATIVE_ERROR = 1.0E-10;
    private static final int LARGE_SAMPLE_PRODUCT = 10000;

    public double kolmogorovSmirnovTest(ContinuousDistribution continuousDistribution, double[] dArray, boolean bl) {
        return 1.0 - this.cdf(this.kolmogorovSmirnovStatistic(continuousDistribution, dArray), dArray.length, bl);
    }

    public double kolmogorovSmirnovStatistic(ContinuousDistribution continuousDistribution, double[] dArray) {
        this.checkArray(dArray);
        int n = dArray.length;
        double d = n;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        Arrays.sort(dArray2);
        double d2 = 0.0;
        for (int i = 1; i <= n; ++i) {
            double d3 = continuousDistribution.cumulativeProbability(dArray2[i - 1]);
            double d4 = FastMath.max(d3 - (double)(i - 1) / d, (double)i / d - d3);
            if (!(d4 > d2)) continue;
            d2 = d4;
        }
        return d2;
    }

    public double kolmogorovSmirnovTest(double[] dArray, double[] dArray2, boolean bl) {
        long l = (long)dArray.length * (long)dArray2.length;
        double[] dArray3 = null;
        double[] dArray4 = null;
        if (l < 10000L && KolmogorovSmirnovTest.hasTies(dArray, dArray2)) {
            dArray3 = MathArrays.copyOf(dArray);
            dArray4 = MathArrays.copyOf(dArray2);
            KolmogorovSmirnovTest.fixTies(dArray3, dArray4);
        } else {
            dArray3 = dArray;
            dArray4 = dArray2;
        }
        if (l < 10000L) {
            return this.exactP(this.kolmogorovSmirnovStatistic(dArray3, dArray4), dArray.length, dArray2.length, bl);
        }
        return this.approximateP(this.kolmogorovSmirnovStatistic(dArray, dArray2), dArray.length, dArray2.length);
    }

    public double kolmogorovSmirnovTest(double[] dArray, double[] dArray2) {
        return this.kolmogorovSmirnovTest(dArray, dArray2, true);
    }

    public double kolmogorovSmirnovStatistic(double[] dArray, double[] dArray2) {
        return (double)this.integralKolmogorovSmirnovStatistic(dArray, dArray2) / (double)((long)dArray.length * (long)dArray2.length);
    }

    private long integralKolmogorovSmirnovStatistic(double[] dArray, double[] dArray2) {
        this.checkArray(dArray);
        this.checkArray(dArray2);
        double[] dArray3 = MathArrays.copyOf(dArray);
        double[] dArray4 = MathArrays.copyOf(dArray2);
        Arrays.sort(dArray3);
        Arrays.sort(dArray4);
        int n = dArray3.length;
        int n2 = dArray4.length;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        long l2 = 0L;
        do {
            double d;
            double d2 = d = Double.compare(dArray3[n3], dArray4[n4]) <= 0 ? dArray3[n3] : dArray4[n4];
            while (n3 < n && Double.compare(dArray3[n3], d) == 0) {
                ++n3;
                l += (long)n2;
            }
            while (n4 < n2 && Double.compare(dArray4[n4], d) == 0) {
                ++n4;
                l -= (long)n;
            }
            if (l > l2) {
                l2 = l;
                continue;
            }
            if (-l <= l2) continue;
            l2 = -l;
        } while (n3 < n && n4 < n2);
        return l2;
    }

    public double kolmogorovSmirnovTest(ContinuousDistribution continuousDistribution, double[] dArray) {
        return this.kolmogorovSmirnovTest(continuousDistribution, dArray, false);
    }

    public boolean kolmogorovSmirnovTest(ContinuousDistribution continuousDistribution, double[] dArray, double d) {
        if (d <= 0.0 || d > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d, 0, 0.5);
        }
        return this.kolmogorovSmirnovTest(continuousDistribution, dArray) < d;
    }

    public double bootstrap(double[] dArray, double[] dArray2, int n, boolean bl, UniformRandomProvider uniformRandomProvider) {
        int n2 = dArray.length;
        int n3 = dArray2.length;
        double[] dArray3 = new double[n2 + n3];
        System.arraycopy(dArray, 0, dArray3, 0, n2);
        System.arraycopy(dArray2, 0, dArray3, n2, n3);
        ContinuousDistribution.Sampler sampler = new EnumeratedRealDistribution(dArray3).createSampler(uniformRandomProvider);
        long l = this.integralKolmogorovSmirnovStatistic(dArray, dArray2);
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            double[] dArray4;
            double[] dArray5 = AbstractRealDistribution.sample(n2, sampler);
            long l2 = this.integralKolmogorovSmirnovStatistic(dArray5, dArray4 = AbstractRealDistribution.sample(n3, sampler));
            if (l2 > l) {
                ++n4;
                continue;
            }
            if (l2 != l) continue;
            ++n5;
        }
        return bl ? (double)n4 / (double)n : (double)(n4 + n5) / (double)n;
    }

    public double cdf(double d, int n) throws MathArithmeticException {
        return this.cdf(d, n, false);
    }

    public double cdfExact(double d, int n) throws MathArithmeticException {
        return this.cdf(d, n, true);
    }

    public double cdf(double d, int n, boolean bl) throws MathArithmeticException {
        double d2 = 1.0 / (double)n;
        double d3 = 0.5 * d2;
        if (d <= d3) {
            return 0.0;
        }
        if (d3 < d && d <= d2) {
            double d4 = 1.0;
            double d5 = 2.0 * d - d2;
            for (int i = 1; i <= n; ++i) {
                d4 *= (double)i * d5;
            }
            return d4;
        }
        if (1.0 - d2 <= d && d < 1.0) {
            return 1.0 - 2.0 * Math.pow(1.0 - d, n);
        }
        if (1.0 <= d) {
            return 1.0;
        }
        if (bl) {
            return this.exactK(d, n);
        }
        if (n <= 140) {
            return this.roundedK(d, n);
        }
        return this.pelzGood(d, n);
    }

    private double exactK(double d, int n) throws MathArithmeticException {
        int n2 = (int)Math.ceil((double)n * d);
        FieldMatrix<BigFraction> fieldMatrix = this.createExactH(d, n);
        FieldMatrix<BigFraction> fieldMatrix2 = fieldMatrix.power(n);
        BigFraction bigFraction = fieldMatrix2.getEntry(n2 - 1, n2 - 1);
        for (int i = 1; i <= n; ++i) {
            bigFraction = bigFraction.multiply(i).divide(n);
        }
        return bigFraction.bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d, int n) {
        int n2 = (int)Math.ceil((double)n * d);
        RealMatrix realMatrix = this.createRoundedH(d, n);
        RealMatrix realMatrix2 = realMatrix.power(n);
        double d2 = realMatrix2.getEntry(n2 - 1, n2 - 1);
        for (int i = 1; i <= n; ++i) {
            d2 *= (double)i / (double)n;
        }
        return d2;
    }

    public double pelzGood(double d, int n) {
        int n2;
        double d2 = FastMath.sqrt(n);
        double d3 = d * d2;
        double d4 = d * d * (double)n;
        double d5 = d4 * d4;
        double d6 = d5 * d4;
        double d7 = d5 * d5;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = Math.PI * Math.PI / (8.0 * d4);
        for (n2 = 1; n2 < 100000 && !((d10 = FastMath.exp(-d12 * (d11 = (double)(2 * n2 - 1)) * d11)) <= 1.0E-10 * (d9 += d10)); ++n2) {
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        d8 = d9 * FastMath.sqrt(Math.PI * 2) / d3;
        double d13 = 2.0 * d4;
        d9 = 0.0;
        d11 = 0.0;
        double d14 = 0.0;
        for (n2 = 0; n2 < 100000; ++n2) {
            d11 = (double)n2 + 0.5;
            d14 = d11 * d11;
            d10 = (Math.PI * Math.PI * d14 - d4) * FastMath.exp(-9.869604401089358 * d14 / d13);
            if (FastMath.abs(d10) < 1.0E-10 * FastMath.abs(d9 += d10)) break;
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        double d15 = FastMath.sqrt(1.5707963267948966);
        d8 += d9 * d15 / (3.0 * d5 * d2);
        double d16 = 2.0 * d5;
        double d17 = 6.0 * d6;
        d12 = 5.0 * d4;
        d9 = 0.0;
        d11 = 0.0;
        d14 = 0.0;
        for (n2 = 0; n2 < 100000; ++n2) {
            d11 = (double)n2 + 0.5;
            d14 = d11 * d11;
            d10 = (d17 + d16 + Math.PI * Math.PI * (d16 - d12) * d14 + 97.40909103400243 * (1.0 - d13) * d14 * d14) * FastMath.exp(-9.869604401089358 * d14 / d13);
            if (FastMath.abs(d10) < 1.0E-10 * FastMath.abs(d9 += d10)) break;
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        double d18 = 0.0;
        d14 = 0.0;
        for (n2 = 1; n2 < 100000; ++n2) {
            d14 = n2 * n2;
            d10 = Math.PI * Math.PI * d14 * FastMath.exp(-9.869604401089358 * d14 / d13);
            if (FastMath.abs(d10) < 1.0E-10 * FastMath.abs(d18 += d10)) break;
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        d8 += d15 / (double)n * (d9 / (36.0 * d4 * d4 * d4 * d3) - d18 / (18.0 * d4 * d3));
        d9 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        for (n2 = 0; n2 < 100000; ++n2) {
            d11 = (double)n2 + 0.5;
            d14 = d11 * d11;
            d19 = d14 * d14;
            d20 = d19 * d14;
            d10 = (961.3891935753043 * d20 * (5.0 - 30.0 * d4) + 97.40909103400243 * d19 * (-60.0 * d4 + 212.0 * d5) + Math.PI * Math.PI * d14 * (135.0 * d5 - 96.0 * d6) - 30.0 * d6 - 90.0 * d7) * FastMath.exp(-9.869604401089358 * d14 / d13);
            if (FastMath.abs(d10) < 1.0E-10 * FastMath.abs(d9 += d10)) break;
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        d18 = 0.0;
        for (n2 = 1; n2 < 100000; ++n2) {
            d14 = n2 * n2;
            d19 = d14 * d14;
            d10 = (-97.40909103400243 * d19 + 29.608813203268074 * d14 * d4) * FastMath.exp(-9.869604401089358 * d14 / d13);
            if (FastMath.abs(d10) < 1.0E-10 * FastMath.abs(d18 += d10)) break;
        }
        if (n2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        return d8 + d15 / (d2 * (double)n) * (d9 / (3240.0 * d6 * d5) + d18 / (108.0 * d6));
    }

    private FieldMatrix<BigFraction> createExactH(double d, int n) throws NumberIsTooLargeException, FractionConversionException {
        int n2;
        int n3 = (int)Math.ceil((double)n * d);
        int n4 = 2 * n3 - 1;
        double d2 = (double)n3 - (double)n * d;
        if (d2 >= 1.0) {
            throw new NumberIsTooLargeException(d2, (Number)1.0, false);
        }
        BigFraction bigFraction = null;
        try {
            bigFraction = new BigFraction(d2, 1.0E-20, 10000);
        }
        catch (FractionConversionException fractionConversionException) {
            try {
                bigFraction = new BigFraction(d2, 1.0E-10, 10000);
            }
            catch (FractionConversionException fractionConversionException2) {
                bigFraction = new BigFraction(d2, 1.0E-5, 10000);
            }
        }
        FieldElement[][] fieldElementArray = new BigFraction[n4][n4];
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                fieldElementArray[i][n2] = i - n2 + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] bigFractionArray = new BigFraction[n4];
        bigFractionArray[0] = bigFraction;
        for (n2 = 1; n2 < n4; ++n2) {
            bigFractionArray[n2] = bigFraction.multiply(bigFractionArray[n2 - 1]);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            fieldElementArray[n2][0] = fieldElementArray[n2][0].subtract(bigFractionArray[n2]);
            fieldElementArray[n4 - 1][n2] = ((BigFraction)fieldElementArray[n4 - 1][n2]).subtract(bigFractionArray[n4 - n2 - 1]);
        }
        if (bigFraction.compareTo(BigFraction.ONE_HALF) == 1) {
            fieldElementArray[n4 - 1][0] = ((BigFraction)fieldElementArray[n4 - 1][0]).add(bigFraction.multiply(2).subtract(1).pow(n4));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n2 + 1; ++i) {
                if (n2 - i + 1 <= 0) continue;
                for (int j = 2; j <= n2 - i + 1; ++j) {
                    fieldElementArray[n2][i] = ((BigFraction)fieldElementArray[n2][i]).divide(j);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), fieldElementArray);
    }

    private RealMatrix createRoundedH(double d, int n) throws NumberIsTooLargeException {
        int n2;
        int n3 = (int)Math.ceil((double)n * d);
        int n4 = 2 * n3 - 1;
        double d2 = (double)n3 - (double)n * d;
        if (d2 >= 1.0) {
            throw new NumberIsTooLargeException(d2, (Number)1.0, false);
        }
        double[][] dArray = new double[n4][n4];
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                dArray[i][n2] = i - n2 + 1 < 0 ? 0.0 : 1.0;
            }
        }
        double[] dArray2 = new double[n4];
        dArray2[0] = d2;
        for (n2 = 1; n2 < n4; ++n2) {
            dArray2[n2] = d2 * dArray2[n2 - 1];
        }
        for (n2 = 0; n2 < n4; ++n2) {
            dArray[n2][0] = dArray[n2][0] - dArray2[n2];
            double[] dArray3 = dArray[n4 - 1];
            int n5 = n2;
            dArray3[n5] = dArray3[n5] - dArray2[n4 - n2 - 1];
        }
        if (Double.compare(d2, 0.5) > 0) {
            double[] dArray4 = dArray[n4 - 1];
            dArray4[0] = dArray4[0] + FastMath.pow(2.0 * d2 - 1.0, n4);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n2 + 1; ++i) {
                if (n2 - i + 1 <= 0) continue;
                for (int j = 2; j <= n2 - i + 1; ++j) {
                    double[] dArray5 = dArray[n2];
                    int n6 = i;
                    dArray5[n6] = dArray5[n6] / (double)j;
                }
            }
        }
        return MatrixUtils.createRealMatrix(dArray);
    }

    private void checkArray(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        }
        if (dArray.length < 2) {
            throw new InsufficientDataException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, dArray.length, 2);
        }
    }

    public double ksSum(double d, double d2, int n) {
        long l;
        if (d == 0.0) {
            return 0.0;
        }
        double d3 = -2.0 * d * d;
        int n2 = -1;
        double d4 = 0.5;
        double d5 = 1.0;
        for (l = 1L; d5 > d2 && l < (long)n; ++l) {
            d5 = FastMath.exp(d3 * (double)l * (double)l);
            d4 += (double)n2 * d5;
            n2 *= -1;
        }
        if (l == (long)n) {
            throw new TooManyIterationsException(n);
        }
        return d4 * 2.0;
    }

    private static long calculateIntegralD(double d, int n, int n2, boolean bl) {
        long l = (long)n * (long)n2;
        long l2 = (long)FastMath.ceil((d - 1.0E-12) * (double)l);
        long l3 = (long)FastMath.floor((d + 1.0E-12) * (double)l);
        if (bl && l3 == l2) {
            return l2 + 1L;
        }
        return l2;
    }

    public double exactP(double d, int n, int n2, boolean bl) {
        return 1.0 - KolmogorovSmirnovTest.n(n2, n, n2, n, KolmogorovSmirnovTest.calculateIntegralD(d, n2, n, bl), bl) / BinomialCoefficientDouble.value(n + n2, n2);
    }

    public double approximateP(double d, int n, int n2) {
        double d2 = n2;
        double d3 = n;
        return 1.0 - this.ksSum(d * FastMath.sqrt(d2 * d3 / (d2 + d3)), 1.0E-20, 100000);
    }

    private static void fillBooleanArrayRandomlyWithFixedNumberTrueValues(boolean[] blArray, int n, UniformRandomProvider uniformRandomProvider) {
        Arrays.fill(blArray, true);
        for (int i = n; i < blArray.length; ++i) {
            blArray[blArray[var4_4 = uniformRandomProvider.nextInt((int)(i + 1))] ? var4_4 : i] = false;
        }
    }

    public double monteCarloP(double d, int n, int n2, boolean bl, int n3, UniformRandomProvider uniformRandomProvider) {
        return this.integralMonteCarloP(KolmogorovSmirnovTest.calculateIntegralD(d, n, n2, bl), n, n2, n3, uniformRandomProvider);
    }

    private double integralMonteCarloP(long l, int n, int n2, int n3, UniformRandomProvider uniformRandomProvider) {
        int n4 = FastMath.max(n, n2);
        int n5 = FastMath.min(n, n2);
        int n6 = n4 + n5;
        int n7 = 0;
        boolean[] blArray = new boolean[n6];
        block0: for (int i = 0; i < n3; ++i) {
            KolmogorovSmirnovTest.fillBooleanArrayRandomlyWithFixedNumberTrueValues(blArray, n4, uniformRandomProvider);
            long l2 = 0L;
            for (int j = 0; j < blArray.length; ++j) {
                if (blArray[j]) {
                    if ((l2 += (long)n5) < l) continue;
                    ++n7;
                    continue block0;
                }
                if ((l2 -= (long)n4) > -l) continue;
                ++n7;
                continue block0;
            }
        }
        return (double)n7 / (double)n3;
    }

    private static void fixTies(double[] dArray, double[] dArray2) {
        if (KolmogorovSmirnovTest.hasTies(dArray, dArray2)) {
            RestorableUniformRandomProvider restorableUniformRandomProvider = RandomSource.create(RandomSource.TWO_CMRES, 7654321, new Object[0]);
            int n = 0;
            boolean bl = true;
            do {
                KolmogorovSmirnovTest.jitter(dArray, restorableUniformRandomProvider, 10);
                KolmogorovSmirnovTest.jitter(dArray2, restorableUniformRandomProvider, 10);
            } while ((bl = KolmogorovSmirnovTest.hasTies(dArray, dArray2)) && ++n < 10);
            if (bl) {
                throw new MathInternalError();
            }
        }
    }

    private static boolean hasTies(double[] dArray, double[] dArray2) {
        double[] dArray3 = MathArrays.unique(MathArrays.concatenate(dArray, dArray2));
        if (Double.isNaN(dArray3[0])) {
            throw new NotANumberException();
        }
        return dArray3.length != dArray.length + dArray2.length;
    }

    private static void jitter(double[] dArray, UniformRandomProvider uniformRandomProvider, int n) {
        int n2 = n * 2;
        for (int i = 0; i < dArray.length; ++i) {
            int n3 = uniformRandomProvider.nextInt(n2) - n;
            int n4 = i;
            dArray[n4] = dArray[n4] + (double)n3 * Math.ulp(dArray[i]);
        }
    }

    private static int c(int n, int n2, int n3, int n4, long l, boolean bl) {
        if (bl) {
            return FastMath.abs((long)n * (long)n4 - (long)n2 * (long)n3) <= l ? 1 : 0;
        }
        return FastMath.abs((long)n * (long)n4 - (long)n2 * (long)n3) < l ? 1 : 0;
    }

    private static double n(int n, int n2, int n3, int n4, long l, boolean bl) {
        int n5;
        double[] dArray = new double[n4];
        double d = 0.0;
        for (n5 = 0; n5 < n4; ++n5) {
            dArray[n5] = KolmogorovSmirnovTest.c(0, n5 + 1, n3, n4, l, bl);
        }
        for (n5 = 1; n5 <= n; ++n5) {
            d = KolmogorovSmirnovTest.c(n5, 0, n3, n4, l, bl);
            for (int i = 1; i <= n2; ++i) {
                dArray[i - 1] = (double)KolmogorovSmirnovTest.c(n5, i, n3, n4, l, bl) * (d + dArray[i - 1]);
                d = dArray[i - 1];
            }
        }
        return d;
    }
}

