/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis;

import org.apache.commons.math4.analysis.BivariateFunction;
import org.apache.commons.math4.analysis.MultivariateFunction;
import org.apache.commons.math4.analysis.MultivariateVectorFunction;
import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.analysis.differentiation.MultivariateDifferentiableFunction;
import org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.analysis.function.Identity;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.numbers.arrays.LinearCombination;

public class FunctionUtils {
    private FunctionUtils() {
    }

    public static UnivariateFunction compose(final UnivariateFunction ... univariateFunctionArray) {
        return new UnivariateFunction(){

            @Override
            public double value(double d) {
                double d2 = d;
                for (int i = univariateFunctionArray.length - 1; i >= 0; --i) {
                    d2 = univariateFunctionArray[i].value(d2);
                }
                return d2;
            }
        };
    }

    public static UnivariateDifferentiableFunction compose(final UnivariateDifferentiableFunction ... univariateDifferentiableFunctionArray) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double d) {
                double d2 = d;
                for (int i = univariateDifferentiableFunctionArray.length - 1; i >= 0; --i) {
                    d2 = univariateDifferentiableFunctionArray[i].value(d2);
                }
                return d2;
            }

            @Override
            public DerivativeStructure value(DerivativeStructure derivativeStructure) {
                DerivativeStructure derivativeStructure2 = derivativeStructure;
                for (int i = univariateDifferentiableFunctionArray.length - 1; i >= 0; --i) {
                    derivativeStructure2 = univariateDifferentiableFunctionArray[i].value(derivativeStructure2);
                }
                return derivativeStructure2;
            }
        };
    }

    public static UnivariateFunction add(final UnivariateFunction ... univariateFunctionArray) {
        return new UnivariateFunction(){

            @Override
            public double value(double d) {
                double d2 = univariateFunctionArray[0].value(d);
                for (int i = 1; i < univariateFunctionArray.length; ++i) {
                    d2 += univariateFunctionArray[i].value(d);
                }
                return d2;
            }
        };
    }

    public static UnivariateDifferentiableFunction add(final UnivariateDifferentiableFunction ... univariateDifferentiableFunctionArray) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double d) {
                double d2 = univariateDifferentiableFunctionArray[0].value(d);
                for (int i = 1; i < univariateDifferentiableFunctionArray.length; ++i) {
                    d2 += univariateDifferentiableFunctionArray[i].value(d);
                }
                return d2;
            }

            @Override
            public DerivativeStructure value(DerivativeStructure derivativeStructure) throws DimensionMismatchException {
                DerivativeStructure derivativeStructure2 = univariateDifferentiableFunctionArray[0].value(derivativeStructure);
                for (int i = 1; i < univariateDifferentiableFunctionArray.length; ++i) {
                    derivativeStructure2 = derivativeStructure2.add(univariateDifferentiableFunctionArray[i].value(derivativeStructure));
                }
                return derivativeStructure2;
            }
        };
    }

    public static UnivariateFunction multiply(final UnivariateFunction ... univariateFunctionArray) {
        return new UnivariateFunction(){

            @Override
            public double value(double d) {
                double d2 = univariateFunctionArray[0].value(d);
                for (int i = 1; i < univariateFunctionArray.length; ++i) {
                    d2 *= univariateFunctionArray[i].value(d);
                }
                return d2;
            }
        };
    }

    public static UnivariateDifferentiableFunction multiply(final UnivariateDifferentiableFunction ... univariateDifferentiableFunctionArray) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double d) {
                double d2 = univariateDifferentiableFunctionArray[0].value(d);
                for (int i = 1; i < univariateDifferentiableFunctionArray.length; ++i) {
                    d2 *= univariateDifferentiableFunctionArray[i].value(d);
                }
                return d2;
            }

            @Override
            public DerivativeStructure value(DerivativeStructure derivativeStructure) {
                DerivativeStructure derivativeStructure2 = univariateDifferentiableFunctionArray[0].value(derivativeStructure);
                for (int i = 1; i < univariateDifferentiableFunctionArray.length; ++i) {
                    derivativeStructure2 = derivativeStructure2.multiply(univariateDifferentiableFunctionArray[i].value(derivativeStructure));
                }
                return derivativeStructure2;
            }
        };
    }

    public static UnivariateFunction combine(final BivariateFunction bivariateFunction, final UnivariateFunction univariateFunction, final UnivariateFunction univariateFunction2) {
        return new UnivariateFunction(){

            @Override
            public double value(double d) {
                return bivariateFunction.value(univariateFunction.value(d), univariateFunction2.value(d));
            }
        };
    }

    public static MultivariateFunction collector(final BivariateFunction bivariateFunction, final UnivariateFunction univariateFunction, final double d) {
        return new MultivariateFunction(){

            @Override
            public double value(double[] dArray) {
                double d2 = bivariateFunction.value(d, univariateFunction.value(dArray[0]));
                for (int i = 1; i < dArray.length; ++i) {
                    d2 = bivariateFunction.value(d2, univariateFunction.value(dArray[i]));
                }
                return d2;
            }
        };
    }

    public static MultivariateFunction collector(BivariateFunction bivariateFunction, double d) {
        return FunctionUtils.collector(bivariateFunction, new Identity(), d);
    }

    public static UnivariateFunction fix1stArgument(final BivariateFunction bivariateFunction, final double d) {
        return new UnivariateFunction(){

            @Override
            public double value(double d2) {
                return bivariateFunction.value(d, d2);
            }
        };
    }

    public static UnivariateFunction fix2ndArgument(final BivariateFunction bivariateFunction, final double d) {
        return new UnivariateFunction(){

            @Override
            public double value(double d2) {
                return bivariateFunction.value(d2, d);
            }
        };
    }

    public static double[] sample(UnivariateFunction univariateFunction, double d, double d2, int n) throws NumberIsTooLargeException, NotStrictlyPositiveException {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        if (d >= d2) {
            throw new NumberIsTooLargeException(d, (Number)d2, false);
        }
        double[] dArray = new double[n];
        double d3 = (d2 - d) / (double)n;
        for (int i = 0; i < n; ++i) {
            dArray[i] = univariateFunction.value(d + (double)i * d3);
        }
        return dArray;
    }

    public static UnivariateDifferentiableFunction toDifferentiable(final UnivariateFunction univariateFunction, final UnivariateFunction ... univariateFunctionArray) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double d) {
                return univariateFunction.value(d);
            }

            @Override
            public DerivativeStructure value(DerivativeStructure derivativeStructure) {
                if (derivativeStructure.getOrder() > univariateFunctionArray.length) {
                    throw new NumberIsTooLargeException(derivativeStructure.getOrder(), (Number)univariateFunctionArray.length, true);
                }
                double[] dArray = new double[derivativeStructure.getOrder() + 1];
                dArray[0] = univariateFunction.value(derivativeStructure.getValue());
                for (int i = 0; i < derivativeStructure.getOrder(); ++i) {
                    dArray[i + 1] = univariateFunctionArray[i].value(derivativeStructure.getValue());
                }
                return derivativeStructure.compose(dArray);
            }
        };
    }

    public static MultivariateDifferentiableFunction toDifferentiable(final MultivariateFunction multivariateFunction, final MultivariateVectorFunction multivariateVectorFunction) {
        return new MultivariateDifferentiableFunction(){

            @Override
            public double value(double[] dArray) {
                return multivariateFunction.value(dArray);
            }

            @Override
            public DerivativeStructure value(DerivativeStructure[] derivativeStructureArray) {
                double[] dArray = new double[derivativeStructureArray.length];
                for (int i = 0; i < derivativeStructureArray.length; ++i) {
                    dArray[i] = derivativeStructureArray[i].getValue();
                    if (derivativeStructureArray[i].getOrder() <= 1) continue;
                    throw new NumberIsTooLargeException(derivativeStructureArray[i].getOrder(), (Number)1, true);
                }
                double d = multivariateFunction.value(dArray);
                double[] dArray2 = multivariateVectorFunction.value(dArray);
                if (dArray2.length != derivativeStructureArray.length) {
                    throw new DimensionMismatchException(dArray2.length, derivativeStructureArray.length);
                }
                int n = derivativeStructureArray[0].getFreeParameters();
                double[] dArray3 = new double[derivativeStructureArray.length];
                double[] dArray4 = new double[n + 1];
                dArray4[0] = d;
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = 1;
                    for (int j = 0; j < derivativeStructureArray.length; ++j) {
                        dArray3[j] = derivativeStructureArray[j].getPartialDerivative(nArray);
                    }
                    nArray[i] = 0;
                    dArray4[i + 1] = LinearCombination.value(dArray2, dArray3);
                }
                return new DerivativeStructure(n, 1, dArray4);
            }
        };
    }

    public static UnivariateFunction derivative(final UnivariateDifferentiableFunction univariateDifferentiableFunction, final int n) {
        return new UnivariateFunction(){

            @Override
            public double value(double d) {
                DerivativeStructure derivativeStructure = new DerivativeStructure(1, n, 0, d);
                return univariateDifferentiableFunction.value(derivativeStructure).getPartialDerivative(n);
            }
        };
    }

    public static MultivariateFunction derivative(final MultivariateDifferentiableFunction multivariateDifferentiableFunction, final int[] nArray) {
        return new MultivariateFunction(){

            @Override
            public double value(double[] dArray) {
                int n = 0;
                int[] objectArray = nArray;
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = objectArray[i];
                    n += n3;
                }
                DerivativeStructure[] derivativeStructureArray = new DerivativeStructure[dArray.length];
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    derivativeStructureArray[n2] = new DerivativeStructure(dArray.length, n, n2, dArray[n2]);
                }
                return multivariateDifferentiableFunction.value(derivativeStructureArray).getPartialDerivative(nArray);
            }
        };
    }
}

