/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.differentiation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math4.Field;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.RealFieldElement;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.numbers.arrays.LinearCombination;
import org.apache.commons.numbers.core.Precision;

public class SparseGradient
implements RealFieldElement<SparseGradient>,
Serializable {
    private static final long serialVersionUID = 20131025L;
    private double value;
    private final Map<Integer, Double> derivatives;

    private SparseGradient(double d, Map<Integer, Double> map) {
        this.value = d;
        this.derivatives = new HashMap<Integer, Double>();
        if (map != null) {
            this.derivatives.putAll(map);
        }
    }

    private SparseGradient(double d, double d2, Map<Integer, Double> map) {
        this.value = d;
        this.derivatives = new HashMap<Integer, Double>();
        if (map != null) {
            for (Map.Entry<Integer, Double> entry : map.entrySet()) {
                this.derivatives.put(entry.getKey(), d2 * entry.getValue());
            }
        }
    }

    public static SparseGradient createConstant(double d) {
        return new SparseGradient(d, Collections.emptyMap());
    }

    public static SparseGradient createVariable(int n, double d) {
        return new SparseGradient(d, Collections.singletonMap(n, 1.0));
    }

    public int numVars() {
        return this.derivatives.size();
    }

    public double getDerivative(int n) {
        Double d = this.derivatives.get(n);
        return d == null ? 0.0 : d;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getReal() {
        return this.value;
    }

    @Override
    public SparseGradient add(SparseGradient sparseGradient) {
        SparseGradient sparseGradient2 = new SparseGradient(this.value + sparseGradient.value, this.derivatives);
        for (Map.Entry<Integer, Double> entry : sparseGradient.derivatives.entrySet()) {
            int n = entry.getKey();
            Double d = sparseGradient2.derivatives.get(n);
            if (d == null) {
                sparseGradient2.derivatives.put(n, entry.getValue());
                continue;
            }
            sparseGradient2.derivatives.put(n, d + entry.getValue());
        }
        return sparseGradient2;
    }

    public void addInPlace(SparseGradient sparseGradient) {
        this.value += sparseGradient.value;
        for (Map.Entry<Integer, Double> entry : sparseGradient.derivatives.entrySet()) {
            int n = entry.getKey();
            Double d = this.derivatives.get(n);
            if (d == null) {
                this.derivatives.put(n, entry.getValue());
                continue;
            }
            this.derivatives.put(n, d + entry.getValue());
        }
    }

    @Override
    public SparseGradient add(double d) {
        SparseGradient sparseGradient = new SparseGradient(this.value + d, this.derivatives);
        return sparseGradient;
    }

    @Override
    public SparseGradient subtract(SparseGradient sparseGradient) {
        SparseGradient sparseGradient2 = new SparseGradient(this.value - sparseGradient.value, this.derivatives);
        for (Map.Entry<Integer, Double> entry : sparseGradient.derivatives.entrySet()) {
            int n = entry.getKey();
            Double d = sparseGradient2.derivatives.get(n);
            if (d == null) {
                sparseGradient2.derivatives.put(n, -entry.getValue().doubleValue());
                continue;
            }
            sparseGradient2.derivatives.put(n, d - entry.getValue());
        }
        return sparseGradient2;
    }

    @Override
    public SparseGradient subtract(double d) {
        return new SparseGradient(this.value - d, this.derivatives);
    }

    @Override
    public SparseGradient multiply(SparseGradient sparseGradient) {
        SparseGradient sparseGradient2 = new SparseGradient(this.value * sparseGradient.value, Collections.emptyMap());
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            sparseGradient2.derivatives.put(entry.getKey(), sparseGradient.value * entry.getValue());
        }
        for (Map.Entry<Integer, Double> entry : sparseGradient.derivatives.entrySet()) {
            int n = entry.getKey();
            Double d = sparseGradient2.derivatives.get(n);
            if (d == null) {
                sparseGradient2.derivatives.put(n, this.value * entry.getValue());
                continue;
            }
            sparseGradient2.derivatives.put(n, d + this.value * entry.getValue());
        }
        return sparseGradient2;
    }

    public void multiplyInPlace(SparseGradient sparseGradient) {
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            this.derivatives.put(entry.getKey(), sparseGradient.value * entry.getValue());
        }
        for (Map.Entry<Integer, Double> entry : sparseGradient.derivatives.entrySet()) {
            int n = entry.getKey();
            Double d = this.derivatives.get(n);
            if (d == null) {
                this.derivatives.put(n, this.value * entry.getValue());
                continue;
            }
            this.derivatives.put(n, d + this.value * entry.getValue());
        }
        this.value *= sparseGradient.value;
    }

    @Override
    public SparseGradient multiply(double d) {
        return new SparseGradient(this.value * d, d, this.derivatives);
    }

    @Override
    public SparseGradient multiply(int n) {
        return new SparseGradient(this.value * (double)n, n, this.derivatives);
    }

    @Override
    public SparseGradient divide(SparseGradient sparseGradient) {
        SparseGradient sparseGradient2 = new SparseGradient(this.value / sparseGradient.value, Collections.emptyMap());
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            sparseGradient2.derivatives.put(entry.getKey(), entry.getValue() / sparseGradient.value);
        }
        for (Map.Entry<Integer, Double> entry : sparseGradient.derivatives.entrySet()) {
            int n = entry.getKey();
            Double d = sparseGradient2.derivatives.get(n);
            if (d == null) {
                sparseGradient2.derivatives.put(n, -sparseGradient2.value / sparseGradient.value * entry.getValue());
                continue;
            }
            sparseGradient2.derivatives.put(n, d - sparseGradient2.value / sparseGradient.value * entry.getValue());
        }
        return sparseGradient2;
    }

    @Override
    public SparseGradient divide(double d) {
        return new SparseGradient(this.value / d, 1.0 / d, this.derivatives);
    }

    @Override
    public SparseGradient negate() {
        return new SparseGradient(-this.value, -1.0, this.derivatives);
    }

    @Override
    public Field<SparseGradient> getField() {
        return new Field<SparseGradient>(){

            @Override
            public SparseGradient getZero() {
                return SparseGradient.createConstant(0.0);
            }

            @Override
            public SparseGradient getOne() {
                return SparseGradient.createConstant(1.0);
            }

            @Override
            public Class<? extends FieldElement<SparseGradient>> getRuntimeClass() {
                return SparseGradient.class;
            }
        };
    }

    @Override
    public SparseGradient remainder(double d) {
        return new SparseGradient(FastMath.IEEEremainder(this.value, d), this.derivatives);
    }

    @Override
    public SparseGradient remainder(SparseGradient sparseGradient) {
        double d = FastMath.IEEEremainder(this.value, sparseGradient.value);
        double d2 = FastMath.rint((this.value - d) / sparseGradient.value);
        return this.subtract(sparseGradient.multiply(d2));
    }

    @Override
    public SparseGradient abs() {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public SparseGradient ceil() {
        return SparseGradient.createConstant(FastMath.ceil(this.value));
    }

    @Override
    public SparseGradient floor() {
        return SparseGradient.createConstant(FastMath.floor(this.value));
    }

    @Override
    public SparseGradient rint() {
        return SparseGradient.createConstant(FastMath.rint(this.value));
    }

    @Override
    public long round() {
        return FastMath.round(this.value);
    }

    @Override
    public SparseGradient signum() {
        return SparseGradient.createConstant(FastMath.signum(this.value));
    }

    @Override
    public SparseGradient copySign(SparseGradient sparseGradient) {
        long l = Double.doubleToLongBits(this.value);
        long l2 = Double.doubleToLongBits(sparseGradient.value);
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public SparseGradient copySign(double d) {
        long l = Double.doubleToLongBits(this.value);
        long l2 = Double.doubleToLongBits(d);
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public SparseGradient scalb(int n) {
        SparseGradient sparseGradient = new SparseGradient(FastMath.scalb(this.value, n), Collections.emptyMap());
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            sparseGradient.derivatives.put(entry.getKey(), FastMath.scalb(entry.getValue(), n));
        }
        return sparseGradient;
    }

    @Override
    public SparseGradient hypot(SparseGradient sparseGradient) {
        int n;
        if (Double.isInfinite(this.value) || Double.isInfinite(sparseGradient.value)) {
            return SparseGradient.createConstant(Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(this.value) || Double.isNaN(sparseGradient.value)) {
            return SparseGradient.createConstant(Double.NaN);
        }
        int n2 = FastMath.getExponent(this.value);
        if (n2 > (n = FastMath.getExponent(sparseGradient.value)) + 27) {
            return this.abs();
        }
        if (n > n2 + 27) {
            return sparseGradient.abs();
        }
        int n3 = (n2 + n) / 2;
        SparseGradient sparseGradient2 = this.scalb(-n3);
        SparseGradient sparseGradient3 = sparseGradient.scalb(-n3);
        SparseGradient sparseGradient4 = sparseGradient2.multiply(sparseGradient2).add(sparseGradient3.multiply(sparseGradient3)).sqrt();
        return sparseGradient4.scalb(n3);
    }

    public static SparseGradient hypot(SparseGradient sparseGradient, SparseGradient sparseGradient2) {
        return sparseGradient.hypot(sparseGradient2);
    }

    @Override
    public SparseGradient reciprocal() {
        return new SparseGradient(1.0 / this.value, -1.0 / (this.value * this.value), this.derivatives);
    }

    @Override
    public SparseGradient sqrt() {
        double d = FastMath.sqrt(this.value);
        return new SparseGradient(d, 0.5 / d, this.derivatives);
    }

    @Override
    public SparseGradient cbrt() {
        double d = FastMath.cbrt(this.value);
        return new SparseGradient(d, 1.0 / (3.0 * d * d), this.derivatives);
    }

    @Override
    public SparseGradient rootN(int n) {
        if (n == 2) {
            return this.sqrt();
        }
        if (n == 3) {
            return this.cbrt();
        }
        double d = FastMath.pow(this.value, 1.0 / (double)n);
        return new SparseGradient(d, 1.0 / ((double)n * FastMath.pow(d, n - 1)), this.derivatives);
    }

    @Override
    public SparseGradient pow(double d) {
        return new SparseGradient(FastMath.pow(this.value, d), d * FastMath.pow(this.value, d - 1.0), this.derivatives);
    }

    @Override
    public SparseGradient pow(int n) {
        if (n == 0) {
            return this.getField().getOne();
        }
        double d = FastMath.pow(this.value, n - 1);
        return new SparseGradient(this.value * d, (double)n * d, this.derivatives);
    }

    @Override
    public SparseGradient pow(SparseGradient sparseGradient) {
        return this.log().multiply(sparseGradient).exp();
    }

    public static SparseGradient pow(double d, SparseGradient sparseGradient) {
        if (d == 0.0) {
            if (sparseGradient.value == 0.0) {
                return sparseGradient.compose(1.0, Double.NEGATIVE_INFINITY);
            }
            if (sparseGradient.value < 0.0) {
                return sparseGradient.compose(Double.NaN, Double.NaN);
            }
            return sparseGradient.getField().getZero();
        }
        double d2 = FastMath.pow(d, sparseGradient.value);
        return new SparseGradient(d2, d2 * FastMath.log(d), sparseGradient.derivatives);
    }

    @Override
    public SparseGradient exp() {
        double d = FastMath.exp(this.value);
        return new SparseGradient(d, d, this.derivatives);
    }

    @Override
    public SparseGradient expm1() {
        return new SparseGradient(FastMath.expm1(this.value), FastMath.exp(this.value), this.derivatives);
    }

    @Override
    public SparseGradient log() {
        return new SparseGradient(FastMath.log(this.value), 1.0 / this.value, this.derivatives);
    }

    @Override
    public SparseGradient log10() {
        return new SparseGradient(FastMath.log10(this.value), 1.0 / (FastMath.log(10.0) * this.value), this.derivatives);
    }

    @Override
    public SparseGradient log1p() {
        return new SparseGradient(FastMath.log1p(this.value), 1.0 / (1.0 + this.value), this.derivatives);
    }

    @Override
    public SparseGradient cos() {
        return new SparseGradient(FastMath.cos(this.value), -FastMath.sin(this.value), this.derivatives);
    }

    @Override
    public SparseGradient sin() {
        return new SparseGradient(FastMath.sin(this.value), FastMath.cos(this.value), this.derivatives);
    }

    @Override
    public SparseGradient tan() {
        double d = FastMath.tan(this.value);
        return new SparseGradient(d, 1.0 + d * d, this.derivatives);
    }

    @Override
    public SparseGradient acos() {
        return new SparseGradient(FastMath.acos(this.value), -1.0 / FastMath.sqrt(1.0 - this.value * this.value), this.derivatives);
    }

    @Override
    public SparseGradient asin() {
        return new SparseGradient(FastMath.asin(this.value), 1.0 / FastMath.sqrt(1.0 - this.value * this.value), this.derivatives);
    }

    @Override
    public SparseGradient atan() {
        return new SparseGradient(FastMath.atan(this.value), 1.0 / (1.0 + this.value * this.value), this.derivatives);
    }

    @Override
    public SparseGradient atan2(SparseGradient sparseGradient) {
        SparseGradient sparseGradient2;
        SparseGradient sparseGradient3 = this.multiply(this).add(sparseGradient.multiply(sparseGradient)).sqrt();
        if (sparseGradient.value >= 0.0) {
            sparseGradient2 = this.divide(sparseGradient3.add(sparseGradient)).atan().multiply(2);
        } else {
            SparseGradient sparseGradient4 = this.divide(sparseGradient3.subtract(sparseGradient)).atan().multiply(-2);
            sparseGradient2 = sparseGradient4.add(sparseGradient4.value <= 0.0 ? -Math.PI : Math.PI);
        }
        sparseGradient2.value = FastMath.atan2(this.value, sparseGradient.value);
        return sparseGradient2;
    }

    public static SparseGradient atan2(SparseGradient sparseGradient, SparseGradient sparseGradient2) {
        return sparseGradient.atan2(sparseGradient2);
    }

    @Override
    public SparseGradient cosh() {
        return new SparseGradient(FastMath.cosh(this.value), FastMath.sinh(this.value), this.derivatives);
    }

    @Override
    public SparseGradient sinh() {
        return new SparseGradient(FastMath.sinh(this.value), FastMath.cosh(this.value), this.derivatives);
    }

    @Override
    public SparseGradient tanh() {
        double d = FastMath.tanh(this.value);
        return new SparseGradient(d, 1.0 - d * d, this.derivatives);
    }

    @Override
    public SparseGradient acosh() {
        return new SparseGradient(FastMath.acosh(this.value), 1.0 / FastMath.sqrt(this.value * this.value - 1.0), this.derivatives);
    }

    @Override
    public SparseGradient asinh() {
        return new SparseGradient(FastMath.asinh(this.value), 1.0 / FastMath.sqrt(this.value * this.value + 1.0), this.derivatives);
    }

    @Override
    public SparseGradient atanh() {
        return new SparseGradient(FastMath.atanh(this.value), 1.0 / (1.0 - this.value * this.value), this.derivatives);
    }

    public SparseGradient toDegrees() {
        return new SparseGradient(FastMath.toDegrees(this.value), FastMath.toDegrees(1.0), this.derivatives);
    }

    public SparseGradient toRadians() {
        return new SparseGradient(FastMath.toRadians(this.value), FastMath.toRadians(1.0), this.derivatives);
    }

    public double taylor(double ... dArray) {
        double d = this.value;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * this.getDerivative(i);
        }
        return d;
    }

    public SparseGradient compose(double d, double d2) {
        return new SparseGradient(d, d2, this.derivatives);
    }

    public SparseGradient linearCombination(SparseGradient[] sparseGradientArray, SparseGradient[] sparseGradientArray2) throws DimensionMismatchException {
        SparseGradient sparseGradient = sparseGradientArray[0].getField().getZero();
        for (int i = 0; i < sparseGradientArray.length; ++i) {
            sparseGradient = sparseGradient.add(sparseGradientArray[i].multiply(sparseGradientArray2[i]));
        }
        double[] dArray = new double[sparseGradientArray.length];
        for (int i = 0; i < sparseGradientArray.length; ++i) {
            dArray[i] = sparseGradientArray[i].getValue();
        }
        double[] dArray2 = new double[sparseGradientArray2.length];
        for (int i = 0; i < sparseGradientArray2.length; ++i) {
            dArray2[i] = sparseGradientArray2[i].getValue();
        }
        sparseGradient.value = LinearCombination.value(dArray, dArray2);
        return sparseGradient;
    }

    public SparseGradient linearCombination(double[] dArray, SparseGradient[] sparseGradientArray) {
        SparseGradient sparseGradient = sparseGradientArray[0].getField().getZero();
        for (int i = 0; i < dArray.length; ++i) {
            sparseGradient = sparseGradient.add(sparseGradientArray[i].multiply(dArray[i]));
        }
        double[] dArray2 = new double[sparseGradientArray.length];
        for (int i = 0; i < sparseGradientArray.length; ++i) {
            dArray2[i] = sparseGradientArray[i].getValue();
        }
        sparseGradient.value = LinearCombination.value(dArray, dArray2);
        return sparseGradient;
    }

    @Override
    public SparseGradient linearCombination(SparseGradient sparseGradient, SparseGradient sparseGradient2, SparseGradient sparseGradient3, SparseGradient sparseGradient4) {
        SparseGradient sparseGradient5 = sparseGradient.multiply(sparseGradient2).add(sparseGradient3.multiply(sparseGradient4));
        sparseGradient5.value = LinearCombination.value(sparseGradient.value, sparseGradient2.value, sparseGradient3.value, sparseGradient4.value);
        return sparseGradient5;
    }

    @Override
    public SparseGradient linearCombination(double d, SparseGradient sparseGradient, double d2, SparseGradient sparseGradient2) {
        SparseGradient sparseGradient3 = sparseGradient.multiply(d).add(sparseGradient2.multiply(d2));
        sparseGradient3.value = LinearCombination.value(d, sparseGradient.value, d2, sparseGradient2.value);
        return sparseGradient3;
    }

    @Override
    public SparseGradient linearCombination(SparseGradient sparseGradient, SparseGradient sparseGradient2, SparseGradient sparseGradient3, SparseGradient sparseGradient4, SparseGradient sparseGradient5, SparseGradient sparseGradient6) {
        SparseGradient sparseGradient7 = sparseGradient.multiply(sparseGradient2).add(sparseGradient3.multiply(sparseGradient4)).add(sparseGradient5.multiply(sparseGradient6));
        sparseGradient7.value = LinearCombination.value(sparseGradient.value, sparseGradient2.value, sparseGradient3.value, sparseGradient4.value, sparseGradient5.value, sparseGradient6.value);
        return sparseGradient7;
    }

    @Override
    public SparseGradient linearCombination(double d, SparseGradient sparseGradient, double d2, SparseGradient sparseGradient2, double d3, SparseGradient sparseGradient3) {
        SparseGradient sparseGradient4 = sparseGradient.multiply(d).add(sparseGradient2.multiply(d2)).add(sparseGradient3.multiply(d3));
        sparseGradient4.value = LinearCombination.value(d, sparseGradient.value, d2, sparseGradient2.value, d3, sparseGradient3.value);
        return sparseGradient4;
    }

    @Override
    public SparseGradient linearCombination(SparseGradient sparseGradient, SparseGradient sparseGradient2, SparseGradient sparseGradient3, SparseGradient sparseGradient4, SparseGradient sparseGradient5, SparseGradient sparseGradient6, SparseGradient sparseGradient7, SparseGradient sparseGradient8) {
        SparseGradient sparseGradient9 = sparseGradient.multiply(sparseGradient2).add(sparseGradient3.multiply(sparseGradient4)).add(sparseGradient5.multiply(sparseGradient6)).add(sparseGradient7.multiply(sparseGradient8));
        sparseGradient9.value = LinearCombination.value(sparseGradient.value, sparseGradient2.value, sparseGradient3.value, sparseGradient4.value, sparseGradient5.value, sparseGradient6.value, sparseGradient7.value, sparseGradient8.value);
        return sparseGradient9;
    }

    @Override
    public SparseGradient linearCombination(double d, SparseGradient sparseGradient, double d2, SparseGradient sparseGradient2, double d3, SparseGradient sparseGradient3, double d4, SparseGradient sparseGradient4) {
        SparseGradient sparseGradient5 = sparseGradient.multiply(d).add(sparseGradient2.multiply(d2)).add(sparseGradient3.multiply(d3)).add(sparseGradient4.multiply(d4));
        sparseGradient5.value = LinearCombination.value(d, sparseGradient.value, d2, sparseGradient2.value, d3, sparseGradient3.value, d4, sparseGradient4.value);
        return sparseGradient5;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SparseGradient) {
            SparseGradient sparseGradient = (SparseGradient)object;
            if (!Precision.equals(this.value, sparseGradient.value, 1)) {
                return false;
            }
            if (this.derivatives.size() != sparseGradient.derivatives.size()) {
                return false;
            }
            for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
                if (!sparseGradient.derivatives.containsKey(entry.getKey())) {
                    return false;
                }
                if (Precision.equals((double)entry.getValue(), (double)sparseGradient.derivatives.get(entry.getKey()), 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 743 + 809 * MathUtils.hash(this.value) + 167 * this.derivatives.hashCode();
    }
}

