/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.Field;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.linear.AbstractFieldMatrix;
import org.apache.commons.math4.linear.FieldMatrix;
import org.apache.commons.math4.util.OpenIntToFieldHashMap;

public class SparseFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T> {
    private final OpenIntToFieldHashMap<T> entries;
    private final int rows;
    private final int columns;

    public SparseFieldMatrix(Field<T> field) {
        super(field);
        this.rows = 0;
        this.columns = 0;
        this.entries = new OpenIntToFieldHashMap<T>(field);
    }

    public SparseFieldMatrix(Field<T> field, int n, int n2) {
        super(field, n, n2);
        this.rows = n;
        this.columns = n2;
        this.entries = new OpenIntToFieldHashMap<T>(field);
    }

    public SparseFieldMatrix(SparseFieldMatrix<T> sparseFieldMatrix) {
        super(sparseFieldMatrix.getField(), sparseFieldMatrix.getRowDimension(), sparseFieldMatrix.getColumnDimension());
        this.rows = sparseFieldMatrix.getRowDimension();
        this.columns = sparseFieldMatrix.getColumnDimension();
        this.entries = new OpenIntToFieldHashMap<T>(sparseFieldMatrix.entries);
    }

    public SparseFieldMatrix(FieldMatrix<T> fieldMatrix) {
        super(fieldMatrix.getField(), fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension());
        this.rows = fieldMatrix.getRowDimension();
        this.columns = fieldMatrix.getColumnDimension();
        this.entries = new OpenIntToFieldHashMap(this.getField());
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.setEntry(i, j, fieldMatrix.getEntry(i, j));
            }
        }
    }

    @Override
    public void addToEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = this.computeKey(n, n2);
        FieldElement fieldElement = (FieldElement)this.entries.get(n3).add(t);
        if (((FieldElement)this.getField().getZero()).equals(fieldElement)) {
            this.entries.remove(n3);
        } else {
            this.entries.put(n3, fieldElement);
        }
    }

    @Override
    public FieldMatrix<T> copy() {
        return new SparseFieldMatrix<T>(this);
    }

    @Override
    public FieldMatrix<T> createMatrix(int n, int n2) {
        return new SparseFieldMatrix(this.getField(), n, n2);
    }

    @Override
    public int getColumnDimension() {
        return this.columns;
    }

    @Override
    public T getEntry(int n, int n2) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        return this.entries.get(this.computeKey(n, n2));
    }

    @Override
    public int getRowDimension() {
        return this.rows;
    }

    @Override
    public void multiplyEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = this.computeKey(n, n2);
        FieldElement fieldElement = (FieldElement)this.entries.get(n3).multiply(t);
        if (((FieldElement)this.getField().getZero()).equals(fieldElement)) {
            this.entries.remove(n3);
        } else {
            this.entries.put(n3, fieldElement);
        }
    }

    @Override
    public void setEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        if (((FieldElement)this.getField().getZero()).equals(t)) {
            this.entries.remove(this.computeKey(n, n2));
        } else {
            this.entries.put(this.computeKey(n, n2), t);
        }
    }

    private int computeKey(int n, int n2) {
        return n * this.columns + n2;
    }
}

