/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.random;

import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RectangularCholeskyDecomposition;
import org.apache.commons.math4.random.NormalizedRandomGenerator;
import org.apache.commons.math4.random.RandomVectorGenerator;

public class CorrelatedRandomVectorGenerator
implements RandomVectorGenerator {
    private final double[] mean;
    private final NormalizedRandomGenerator generator;
    private final double[] normalized;
    private final RealMatrix root;

    public CorrelatedRandomVectorGenerator(double[] dArray, RealMatrix realMatrix, double d, NormalizedRandomGenerator normalizedRandomGenerator) {
        int n = realMatrix.getRowDimension();
        if (dArray.length != n) {
            throw new DimensionMismatchException(dArray.length, n);
        }
        this.mean = (double[])dArray.clone();
        RectangularCholeskyDecomposition rectangularCholeskyDecomposition = new RectangularCholeskyDecomposition(realMatrix, d);
        this.root = rectangularCholeskyDecomposition.getRootMatrix();
        this.generator = normalizedRandomGenerator;
        this.normalized = new double[rectangularCholeskyDecomposition.getRank()];
    }

    public CorrelatedRandomVectorGenerator(RealMatrix realMatrix, double d, NormalizedRandomGenerator normalizedRandomGenerator) {
        int n = realMatrix.getRowDimension();
        this.mean = new double[n];
        for (int i = 0; i < n; ++i) {
            this.mean[i] = 0.0;
        }
        RectangularCholeskyDecomposition rectangularCholeskyDecomposition = new RectangularCholeskyDecomposition(realMatrix, d);
        this.root = rectangularCholeskyDecomposition.getRootMatrix();
        this.generator = normalizedRandomGenerator;
        this.normalized = new double[rectangularCholeskyDecomposition.getRank()];
    }

    public NormalizedRandomGenerator getGenerator() {
        return this.generator;
    }

    public int getRank() {
        return this.normalized.length;
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    @Override
    public double[] nextVector() {
        for (int i = 0; i < this.normalized.length; ++i) {
            this.normalized[i] = this.generator.nextNormalizedDouble();
        }
        double[] dArray = new double[this.mean.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.mean[i];
            for (int j = 0; j < this.root.getColumnDimension(); ++j) {
                int n = i;
                dArray[n] = dArray[n] + this.root.getEntry(i, j) * this.normalized[j];
            }
        }
        return dArray;
    }
}

