/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.random;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NotANumberException;
import org.apache.commons.math4.exception.NotFiniteNumberException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.rng.UniformRandomProvider;

public class RandomUtils {
    private RandomUtils() {
    }

    public static DataGenerator createDataGenerator(UniformRandomProvider uniformRandomProvider) {
        return new DataGenerator(uniformRandomProvider);
    }

    public static DataGenerator createDataGenerator(Random random) {
        return RandomUtils.createDataGenerator(RandomUtils.asUniformRandomProvider(random));
    }

    public static UniformRandomProvider asUniformRandomProvider(final Random random) {
        return new UniformRandomProvider(){

            @Override
            public void nextBytes(byte[] byArray) {
                random.nextBytes(byArray);
            }

            @Override
            public void nextBytes(byte[] byArray, int n, int n2) {
                byte[] byArray2 = new byte[n2];
                random.nextBytes(byArray2);
                System.arraycopy(byArray2, 0, byArray, n, n2);
            }

            @Override
            public int nextInt() {
                return random.nextInt();
            }

            @Override
            public int nextInt(int n) {
                if (n <= 0) {
                    throw new NotStrictlyPositiveException(n);
                }
                return random.nextInt(n);
            }

            @Override
            public long nextLong() {
                return random.nextLong();
            }

            @Override
            public long nextLong(long l) {
                if (l > 0L) {
                    long l2;
                    long l3;
                    while ((l3 = random.nextLong() >>> 1) - (l2 = l3 % l) + (l - 1L) < 0L) {
                    }
                    return l2;
                }
                throw new NotStrictlyPositiveException(l);
            }

            @Override
            public boolean nextBoolean() {
                return random.nextBoolean();
            }

            @Override
            public float nextFloat() {
                return random.nextFloat();
            }

            @Override
            public double nextDouble() {
                return random.nextDouble();
            }
        };
    }

    public static class DataGenerator {
        private final UniformRandomProvider rng;

        DataGenerator(UniformRandomProvider uniformRandomProvider) {
            this.rng = uniformRandomProvider;
        }

        public String nextHexString(int n, boolean bl) {
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, n);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!bl) {
                byte[] byArray = new byte[n / 2 + 1];
                this.rng.nextBytes(byArray);
                for (int i = 0; i < byArray.length; ++i) {
                    Integer n2 = byArray[i];
                    Object object = Integer.toHexString(n2 + 128);
                    if (((String)object).length() == 1) {
                        object = "0" + (String)object;
                    }
                    stringBuilder.append((String)object);
                }
            } else {
                MessageDigest messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new MathInternalError(noSuchAlgorithmException);
                }
                messageDigest.reset();
                int n3 = n / 40 + 1;
                for (int i = 1; i < n3 + 1; ++i) {
                    byte[] byArray = new byte[40];
                    this.rng.nextBytes(byArray);
                    messageDigest.update(byArray);
                    byte[] byArray2 = messageDigest.digest();
                    for (int j = 0; j < byArray2.length; ++j) {
                        Integer n4 = byArray2[j];
                        Object object = Integer.toHexString(n4 + 128);
                        if (((String)object).length() == 1) {
                            object = "0" + (String)object;
                        }
                        stringBuilder.append((String)object);
                    }
                }
            }
            return stringBuilder.toString().substring(0, n);
        }

        public long nextLong(long l, long l2) {
            if (l >= l2) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)l, l2, false);
            }
            long l3 = l2 - l + 1L;
            if (l3 <= 0L) {
                long l4;
                while ((l4 = this.rng.nextLong()) < l || l4 > l2) {
                }
                return l4;
            }
            if (l3 < Integer.MAX_VALUE) {
                return l + (long)this.rng.nextInt((int)l3);
            }
            return l + this.rng.nextLong(l3);
        }

        public double nextUniform(double d, double d2) {
            return this.nextUniform(d, d2, false);
        }

        public double nextUniform(double d, double d2, boolean bl) {
            if (d >= d2) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)d, d2, false);
            }
            if (Double.isInfinite(d)) {
                throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d, new Object[0]);
            }
            if (Double.isInfinite(d2)) {
                throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d2, new Object[0]);
            }
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                throw new NotANumberException();
            }
            double d3 = this.rng.nextDouble();
            while (!bl && d3 <= 0.0) {
                d3 = this.rng.nextDouble();
            }
            return d3 * d2 + (1.0 - d3) * d;
        }
    }
}

