/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractXoShiRo256
extends LongProvider {
    private static final int SEED_SIZE = 4;
    protected long state0;
    protected long state1;
    protected long state2;
    protected long state3;

    AbstractXoShiRo256(long[] lArray) {
        if (lArray.length < 4) {
            long[] lArray2 = new long[4];
            this.fillState(lArray2, lArray);
            this.setState(lArray2);
        } else {
            this.setState(lArray);
        }
    }

    AbstractXoShiRo256(long l, long l2, long l3, long l4) {
        this.state0 = l;
        this.state1 = l2;
        this.state2 = l3;
        this.state3 = l4;
    }

    private void setState(long[] lArray) {
        this.state0 = lArray[0];
        this.state1 = lArray[1];
        this.state2 = lArray[2];
        this.state3 = lArray[3];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state0, this.state1, this.state2, this.state3}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 32);
        this.setState(NumberFactory.makeLongArray(byArray2[0]));
        super.setStateInternal(byArray2[1]);
    }
}

