/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class TwoCmres
extends LongProvider {
    private static final String INTERNAL_ERROR_MSG = "Internal error: Please file a bug report";
    private static final byte SEED_GUARD = 9;
    private static final Cmres.Factory FACTORY = new Cmres.Factory();
    private final Cmres x;
    private final Cmres y;
    private long xx;
    private long yy;

    private TwoCmres(int n, Cmres cmres, Cmres cmres2) {
        if (cmres == cmres2) {
            throw new IllegalArgumentException("Subcycle generators must be different");
        }
        this.x = cmres;
        this.y = cmres2;
        this.setSeedInternal(n);
    }

    public TwoCmres(Integer n) {
        this(n, 0, 1);
    }

    public TwoCmres(Integer n, int n2, int n3) {
        this((int)n, FACTORY.get(n2), FACTORY.get(n3));
    }

    @Override
    public long next() {
        this.xx = this.x.transform(this.xx);
        this.yy = this.y.transform(this.yy);
        return this.xx + this.yy;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.x + " + " + this.y + ")";
    }

    public static int numberOfSubcycleGenerators() {
        return FACTORY.numberOfSubcycleGenerators();
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.xx, this.yy}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 16);
        long[] lArray = NumberFactory.makeLongArray(byArray2[0]);
        this.xx = lArray[0];
        this.yy = lArray[1];
        super.setStateInternal(byArray2[1]);
    }

    private void setSeedInternal(int n) {
        int n2;
        int n3 = (n & 0xFFFF) + 9;
        int n4 = (n >>> 16) + 9;
        if (n3 < 0 || n4 < 0) {
            throw new IllegalStateException(INTERNAL_ERROR_MSG);
        }
        this.xx = this.x.getStart();
        for (n2 = n3; n2 > 0; --n2) {
            this.xx = this.x.transform(this.xx);
        }
        this.yy = this.y.getStart();
        for (n2 = n4; n2 > 0; --n2) {
            this.yy = this.y.transform(this.yy);
        }
    }

    static class Cmres {
        private static final String SEP = ", ";
        private static final String HEX_FORMAT = "0x%016xL";
        private final int start;
        private final long multiply;
        private final int rotate;

        Cmres(long l, int n, int n2) {
            this.multiply = l;
            this.rotate = n;
            this.start = n2;
        }

        public String toString() {
            String string = String.format((Locale)null, HEX_FORMAT, this.multiply);
            return "Cmres: [" + string + SEP + this.rotate + SEP + this.start + "]";
        }

        public long getMultiply() {
            return this.multiply;
        }

        public int getStart() {
            return this.start;
        }

        long transform(long l) {
            long l2 = l;
            l2 *= this.multiply;
            l2 = this.rotl(l2);
            return l2 -= l;
        }

        private long rotl(long l) {
            return l << this.rotate | l >>> 64 - this.rotate;
        }

        static class Factory {
            private static final List<Cmres> TABLE = new ArrayList<Cmres>();

            Factory() {
            }

            int numberOfSubcycleGenerators() {
                return TABLE.size();
            }

            Cmres get(int n) {
                if (n < 0 || n >= TABLE.size()) {
                    throw new IndexOutOfBoundsException("Out of interval [0, " + (TABLE.size() - 1) + "]");
                }
                return TABLE.get(n);
            }

            private static void add(long l, int n, int n2) {
                Factory.checkUnique(TABLE, l);
                TABLE.add(new Cmres(l, n, n2));
            }

            static void checkUnique(List<Cmres> list, long l) {
                for (Cmres cmres : list) {
                    if (l != cmres.getMultiply()) continue;
                    throw new IllegalStateException(TwoCmres.INTERNAL_ERROR_MSG);
                }
            }

            static {
                Factory.add(-1311035227701529639L, 33, 330658535);
                Factory.add(-4200785911283159561L, 33, 331932042);
                Factory.add(-2480995517876793755L, 31, 115147686);
                Factory.add(8892696302929846813L, 31, 373734283);
                Factory.add(896991281930355499L, 33, 100747837);
                Factory.add(-2821069675138505015L, 33, 21922933);
                Factory.add(-3818034597552471025L, 31, 8815805);
                Factory.add(-8823573168932131537L, 32, 231265826);
                Factory.add(5515758818646274343L, 33, 191570124);
                Factory.add(1291046001440519745L, 32, 106120225);
                Factory.add(-4856050793788397315L, 31, 496739341);
                Factory.add(1086781239490809013L, 33, 0xB7B7B67);
                Factory.add(-5926327289273887825L, 31, 645874071);
                Factory.add(-8067236098409593127L, 31, 37513605);
            }
        }
    }
}

