/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.util;

import java.util.Arrays;

public final class NumberFactory {
    private static final float FLOAT_MULTIPLIER = 5.9604645E-8f;
    private static final double DOUBLE_MULTIPLIER = (double)1.110223E-16f;
    private static final long LONG_LOWEST_BYTE_MASK = 255L;
    private static final int LONG_SIZE = 8;
    private static final int INT_LOWEST_BYTE_MASK = 255;
    private static final int INT_SIZE = 4;

    private NumberFactory() {
    }

    @Deprecated
    public static boolean makeBoolean(int n) {
        return n >>> 31 != 0;
    }

    @Deprecated
    public static boolean makeBoolean(long l) {
        return l >>> 63 != 0L;
    }

    public static double makeDouble(long l) {
        return (double)(l >>> 11) * (double)1.110223E-16f;
    }

    public static double makeDouble(int n, int n2) {
        long l = (long)(n >>> 6) << 27;
        int n3 = n2 >>> 5;
        return (double)(l | (long)n3) * (double)1.110223E-16f;
    }

    public static float makeFloat(int n) {
        return (float)(n >>> 8) * 5.9604645E-8f;
    }

    public static long makeLong(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    @Deprecated
    public static int makeInt(long l) {
        return NumberFactory.extractHi(l) ^ NumberFactory.extractLo(l);
    }

    public static int extractHi(long l) {
        return (int)(l >>> 32);
    }

    public static int extractLo(long l) {
        return (int)l;
    }

    public static byte[] makeByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int n = i * 8;
            byArray[i] = (byte)(l >>> n & 0xFFL);
        }
        return byArray;
    }

    public static long makeLong(byte[] byArray) {
        NumberFactory.checkSize(8, byArray.length);
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            int n = i * 8;
            l |= ((long)byArray[i] & 0xFFL) << n;
        }
        return l;
    }

    public static byte[] makeByteArray(long[] lArray) {
        int n = lArray.length * 8;
        byte[] byArray = new byte[n];
        for (int i = 0; i < lArray.length; ++i) {
            byte[] byArray2 = NumberFactory.makeByteArray(lArray[i]);
            System.arraycopy(byArray2, 0, byArray, i * 8, 8);
        }
        return byArray;
    }

    public static long[] makeLongArray(byte[] byArray) {
        int n = byArray.length;
        int n2 = n / 8;
        NumberFactory.checkSize(n2 * 8, n);
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = i * 8;
            byte[] byArray2 = Arrays.copyOfRange(byArray, n3, n3 + 8);
            lArray[i] = NumberFactory.makeLong(byArray2);
        }
        return lArray;
    }

    public static byte[] makeByteArray(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n2 = i * 8;
            byArray[i] = (byte)(n >>> n2 & 0xFF);
        }
        return byArray;
    }

    public static int makeInt(byte[] byArray) {
        NumberFactory.checkSize(4, byArray.length);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = i * 8;
            n |= (byArray[i] & 0xFF) << n2;
        }
        return n;
    }

    public static byte[] makeByteArray(int[] nArray) {
        int n = nArray.length * 4;
        byte[] byArray = new byte[n];
        for (int i = 0; i < nArray.length; ++i) {
            byte[] byArray2 = NumberFactory.makeByteArray(nArray[i]);
            System.arraycopy(byArray2, 0, byArray, i * 4, 4);
        }
        return byArray;
    }

    public static int[] makeIntArray(byte[] byArray) {
        int n = byArray.length;
        int n2 = n / 4;
        NumberFactory.checkSize(n2 * 4, n);
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = i * 4;
            byte[] byArray2 = Arrays.copyOfRange(byArray, n3, n3 + 4);
            nArray[i] = NumberFactory.makeInt(byArray2);
        }
        return nArray;
    }

    private static void checkSize(int n, int n2) {
        if (n != n2) {
            throw new IllegalArgumentException("Array size: Expected " + n + " but was " + n2);
        }
    }
}

