/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class ContinuousUniformSampler
extends SamplerBase
implements ContinuousSampler {
    private final double lo;
    private final double hi;
    private final UniformRandomProvider rng;

    public ContinuousUniformSampler(UniformRandomProvider uniformRandomProvider, double d, double d2) {
        super(null);
        this.rng = uniformRandomProvider;
        this.lo = d;
        this.hi = d2;
    }

    @Override
    public double sample() {
        double d = this.rng.nextDouble();
        return d * this.hi + (1.0 - d) * this.lo;
    }

    @Override
    public String toString() {
        return "Uniform deviate [" + this.rng.toString() + "]";
    }
}

