/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.common;

import io.virtdata.discrete.common.ThreadSafeHash;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;

public class InterpolatingIntDoubleSampler
implements IntToDoubleFunction {
    private final double[] lut;
    private final DoubleUnaryOperator f;
    private int resolution;
    private final boolean clamp;
    private final double clampMax;
    private ThreadSafeHash hash;

    public InterpolatingIntDoubleSampler(DoubleUnaryOperator doubleUnaryOperator, int n, boolean bl, boolean bl2, double d) {
        this.f = doubleUnaryOperator;
        this.resolution = n;
        this.clamp = bl2;
        this.clampMax = d;
        if (bl) {
            this.hash = new ThreadSafeHash();
        }
        this.lut = this.precompute();
    }

    private double[] precompute() {
        double[] dArray = new double[this.resolution + 2];
        for (int i = 0; i <= this.resolution; ++i) {
            double d;
            double d2 = (double)i / (double)this.resolution;
            dArray[i] = d = this.clamp ? Double.min(this.clampMax, this.f.applyAsDouble(d2)) : this.f.applyAsDouble(d2);
        }
        dArray[dArray.length - 1] = 0.0;
        return dArray;
    }

    @Override
    public double applyAsDouble(int n) {
        long l = n;
        if (this.hash != null) {
            l = this.hash.applyAsLong(l);
        }
        double d = (double)l / 9.223372036854776E18;
        double d2 = d * (double)this.resolution;
        int n2 = (int)d2;
        double d3 = d2 - (double)n2;
        double d4 = this.lut[n2] * (1.0 - d3);
        double d5 = this.lut[n2 + 1] * d3;
        double d6 = d4 + d5;
        return d6;
    }
}

