/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive;

import io.virtdata.shaded.oac.statistics.descriptive.StatisticalMultivariateSummary;
import io.virtdata.shaded.oac.statistics.descriptive.StorelessUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.moment.GeometricMean;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Mean;
import io.virtdata.shaded.oac.statistics.descriptive.moment.VectorialCovariance;
import io.virtdata.shaded.oac.statistics.descriptive.rank.Max;
import io.virtdata.shaded.oac.statistics.descriptive.rank.Min;
import io.virtdata.shaded.oac.statistics.descriptive.summary.Sum;
import io.virtdata.shaded.oac.statistics.descriptive.summary.SumOfLogs;
import io.virtdata.shaded.oac.statistics.descriptive.summary.SumOfSquares;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathIllegalStateException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.numbers.core.Precision;

public class MultivariateSummaryStatistics
implements StatisticalMultivariateSummary,
Serializable {
    private static final long serialVersionUID = 2271900808994826718L;
    private final int k;
    private long n = 0L;
    private final StorelessUnivariateStatistic[] sumImpl;
    private final StorelessUnivariateStatistic[] sumSqImpl;
    private final StorelessUnivariateStatistic[] minImpl;
    private final StorelessUnivariateStatistic[] maxImpl;
    private final StorelessUnivariateStatistic[] sumLogImpl;
    private final StorelessUnivariateStatistic[] geoMeanImpl;
    private final StorelessUnivariateStatistic[] meanImpl;
    private final VectorialCovariance covarianceImpl;

    public MultivariateSummaryStatistics(int n, boolean bl) {
        this.k = n;
        this.sumImpl = new StorelessUnivariateStatistic[n];
        this.sumSqImpl = new StorelessUnivariateStatistic[n];
        this.minImpl = new StorelessUnivariateStatistic[n];
        this.maxImpl = new StorelessUnivariateStatistic[n];
        this.sumLogImpl = new StorelessUnivariateStatistic[n];
        this.geoMeanImpl = new StorelessUnivariateStatistic[n];
        this.meanImpl = new StorelessUnivariateStatistic[n];
        for (int i = 0; i < n; ++i) {
            this.sumImpl[i] = new Sum();
            this.sumSqImpl[i] = new SumOfSquares();
            this.minImpl[i] = new Min();
            this.maxImpl[i] = new Max();
            this.sumLogImpl[i] = new SumOfLogs();
            this.geoMeanImpl[i] = new GeometricMean();
            this.meanImpl[i] = new Mean();
        }
        this.covarianceImpl = new VectorialCovariance(n, bl);
    }

    public void addValue(double[] dArray) throws DimensionMismatchException {
        this.checkDimension(dArray.length);
        for (int i = 0; i < this.k; ++i) {
            double d = dArray[i];
            this.sumImpl[i].increment(d);
            this.sumSqImpl[i].increment(d);
            this.minImpl[i].increment(d);
            this.maxImpl[i].increment(d);
            this.sumLogImpl[i].increment(d);
            this.geoMeanImpl[i].increment(d);
            this.meanImpl[i].increment(d);
        }
        this.covarianceImpl.increment(dArray);
        ++this.n;
    }

    @Override
    public int getDimension() {
        return this.k;
    }

    @Override
    public long getN() {
        return this.n;
    }

    private double[] getResults(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        double[] dArray = new double[storelessUnivariateStatisticArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = storelessUnivariateStatisticArray[i].getResult();
        }
        return dArray;
    }

    @Override
    public double[] getSum() {
        return this.getResults(this.sumImpl);
    }

    @Override
    public double[] getSumSq() {
        return this.getResults(this.sumSqImpl);
    }

    @Override
    public double[] getSumLog() {
        return this.getResults(this.sumLogImpl);
    }

    @Override
    public double[] getMean() {
        return this.getResults(this.meanImpl);
    }

    @Override
    public double[] getStandardDeviation() {
        double[] dArray = new double[this.k];
        if (this.getN() < 1L) {
            Arrays.fill(dArray, Double.NaN);
        } else if (this.getN() < 2L) {
            Arrays.fill(dArray, 0.0);
        } else {
            RealMatrix realMatrix = this.covarianceImpl.getResult();
            for (int i = 0; i < this.k; ++i) {
                dArray[i] = FastMath.sqrt(realMatrix.getEntry(i, i));
            }
        }
        return dArray;
    }

    @Override
    public RealMatrix getCovariance() {
        return this.covarianceImpl.getResult();
    }

    @Override
    public double[] getMax() {
        return this.getResults(this.maxImpl);
    }

    @Override
    public double[] getMin() {
        return this.getResults(this.minImpl);
    }

    @Override
    public double[] getGeometricMean() {
        return this.getResults(this.geoMeanImpl);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MultivariateSummaryStatistics:").append(string);
        stringBuilder.append("n: ").append(this.getN()).append(string);
        this.append(stringBuilder, this.getMin(), "min: ", ", ", string);
        this.append(stringBuilder, this.getMax(), "max: ", ", ", string);
        this.append(stringBuilder, this.getMean(), "mean: ", ", ", string);
        this.append(stringBuilder, this.getGeometricMean(), "geometric mean: ", ", ", string);
        this.append(stringBuilder, this.getSumSq(), "sum of squares: ", ", ", string);
        this.append(stringBuilder, this.getSumLog(), "sum of logarithms: ", ", ", string);
        this.append(stringBuilder, this.getStandardDeviation(), "standard deviation: ", ", ", string);
        stringBuilder.append("covariance: ").append(this.getCovariance()).append(string);
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, double[] dArray, String string, String string2, String string3) {
        stringBuilder.append(string);
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(dArray[i]);
        }
        stringBuilder.append(string3);
    }

    public void clear() {
        this.n = 0L;
        for (int i = 0; i < this.k; ++i) {
            this.minImpl[i].clear();
            this.maxImpl[i].clear();
            this.sumImpl[i].clear();
            this.sumLogImpl[i].clear();
            this.sumSqImpl[i].clear();
            this.geoMeanImpl[i].clear();
            this.meanImpl[i].clear();
        }
        this.covarianceImpl.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultivariateSummaryStatistics)) {
            return false;
        }
        MultivariateSummaryStatistics multivariateSummaryStatistics = (MultivariateSummaryStatistics)object;
        return MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getGeometricMean(), this.getGeometricMean()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getMax(), this.getMax()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getMean(), this.getMean()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getMin(), this.getMin()) && Precision.equalsIncludingNaN(multivariateSummaryStatistics.getN(), this.getN()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getSum(), this.getSum()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getSumSq(), this.getSumSq()) && MathArrays.equalsIncludingNaN(multivariateSummaryStatistics.getSumLog(), this.getSumLog()) && multivariateSummaryStatistics.getCovariance().equals(this.getCovariance());
    }

    public int hashCode() {
        int n = 31 + MathUtils.hash(this.getGeometricMean());
        n = n * 31 + MathUtils.hash(this.getGeometricMean());
        n = n * 31 + MathUtils.hash(this.getMax());
        n = n * 31 + MathUtils.hash(this.getMean());
        n = n * 31 + MathUtils.hash(this.getMin());
        n = n * 31 + MathUtils.hash(this.getN());
        n = n * 31 + MathUtils.hash(this.getSum());
        n = n * 31 + MathUtils.hash(this.getSumSq());
        n = n * 31 + MathUtils.hash(this.getSumLog());
        n = n * 31 + this.getCovariance().hashCode();
        return n;
    }

    private void setImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray, StorelessUnivariateStatistic[] storelessUnivariateStatisticArray2) throws MathIllegalStateException, DimensionMismatchException {
        this.checkEmpty();
        this.checkDimension(storelessUnivariateStatisticArray.length);
        System.arraycopy(storelessUnivariateStatisticArray, 0, storelessUnivariateStatisticArray2, 0, storelessUnivariateStatisticArray.length);
    }

    public StorelessUnivariateStatistic[] getSumImpl() {
        return (StorelessUnivariateStatistic[])this.sumImpl.clone();
    }

    public void setSumImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) throws MathIllegalStateException, DimensionMismatchException {
        this.setImpl(storelessUnivariateStatisticArray, this.sumImpl);
    }

    public StorelessUnivariateStatistic[] getSumsqImpl() {
        return (StorelessUnivariateStatistic[])this.sumSqImpl.clone();
    }

    public void setSumsqImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) throws MathIllegalStateException, DimensionMismatchException {
        this.setImpl(storelessUnivariateStatisticArray, this.sumSqImpl);
    }

    public StorelessUnivariateStatistic[] getMinImpl() {
        return (StorelessUnivariateStatistic[])this.minImpl.clone();
    }

    public void setMinImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) throws MathIllegalStateException, DimensionMismatchException {
        this.setImpl(storelessUnivariateStatisticArray, this.minImpl);
    }

    public StorelessUnivariateStatistic[] getMaxImpl() {
        return (StorelessUnivariateStatistic[])this.maxImpl.clone();
    }

    public void setMaxImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) throws MathIllegalStateException, DimensionMismatchException {
        this.setImpl(storelessUnivariateStatisticArray, this.maxImpl);
    }

    public StorelessUnivariateStatistic[] getSumLogImpl() {
        return (StorelessUnivariateStatistic[])this.sumLogImpl.clone();
    }

    public void setSumLogImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) throws MathIllegalStateException, DimensionMismatchException {
        this.setImpl(storelessUnivariateStatisticArray, this.sumLogImpl);
    }

    public StorelessUnivariateStatistic[] getGeoMeanImpl() {
        return (StorelessUnivariateStatistic[])this.geoMeanImpl.clone();
    }

    public void setGeoMeanImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) throws MathIllegalStateException, DimensionMismatchException {
        this.setImpl(storelessUnivariateStatisticArray, this.geoMeanImpl);
    }

    public StorelessUnivariateStatistic[] getMeanImpl() {
        return (StorelessUnivariateStatistic[])this.meanImpl.clone();
    }

    public void setMeanImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) throws MathIllegalStateException, DimensionMismatchException {
        this.setImpl(storelessUnivariateStatisticArray, this.meanImpl);
    }

    private void checkEmpty() throws MathIllegalStateException {
        if (this.n > 0L) {
            throw new MathIllegalStateException(LocalizedFormats.VALUES_ADDED_BEFORE_CONFIGURING_STATISTIC, this.n);
        }
    }

    private void checkDimension(int n) throws DimensionMismatchException {
        if (n != this.k) {
            throw new DimensionMismatchException(n, this.k);
        }
    }
}

