/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.moment;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.moment.SecondMoment;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Variance;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;

public class StandardDeviation
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private Variance variance = null;

    public StandardDeviation() {
        this.variance = new Variance();
    }

    public StandardDeviation(SecondMoment secondMoment) {
        this.variance = new Variance(secondMoment);
    }

    public StandardDeviation(StandardDeviation standardDeviation) throws NullArgumentException {
        StandardDeviation.copy(standardDeviation, this);
    }

    public StandardDeviation(boolean bl) {
        this.variance = new Variance(bl);
    }

    public StandardDeviation(boolean bl, SecondMoment secondMoment) {
        this.variance = new Variance(bl, secondMoment);
    }

    @Override
    public void increment(double d) {
        this.variance.increment(d);
    }

    @Override
    public long getN() {
        return this.variance.getN();
    }

    @Override
    public double getResult() {
        return FastMath.sqrt(this.variance.getResult());
    }

    @Override
    public void clear() {
        this.variance.clear();
    }

    @Override
    public double evaluate(double[] dArray) throws MathIllegalArgumentException {
        return FastMath.sqrt(this.variance.evaluate(dArray));
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return FastMath.sqrt(this.variance.evaluate(dArray, n, n2));
    }

    public double evaluate(double[] dArray, double d, int n, int n2) throws MathIllegalArgumentException {
        return FastMath.sqrt(this.variance.evaluate(dArray, d, n, n2));
    }

    public double evaluate(double[] dArray, double d) throws MathIllegalArgumentException {
        return FastMath.sqrt(this.variance.evaluate(dArray, d));
    }

    public boolean isBiasCorrected() {
        return this.variance.isBiasCorrected();
    }

    public void setBiasCorrected(boolean bl) {
        this.variance.setBiasCorrected(bl);
    }

    @Override
    public StandardDeviation copy() {
        StandardDeviation standardDeviation = new StandardDeviation();
        StandardDeviation.copy(this, standardDeviation);
        return standardDeviation;
    }

    public static void copy(StandardDeviation standardDeviation, StandardDeviation standardDeviation2) throws NullArgumentException {
        MathUtils.checkNotNull(standardDeviation);
        MathUtils.checkNotNull(standardDeviation2);
        standardDeviation2.variance = standardDeviation.variance.copy();
    }
}

