/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.summary;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private int n;
    private double value;

    public SumOfLogs() {
        this.value = 0.0;
        this.n = 0;
    }

    public SumOfLogs(SumOfLogs sumOfLogs) throws NullArgumentException {
        SumOfLogs.copy(sumOfLogs, this);
    }

    @Override
    public void increment(double d) {
        this.value += FastMath.log(d);
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, n, n2, true)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += FastMath.log(dArray[i]);
            }
        }
        return d;
    }

    @Override
    public SumOfLogs copy() {
        SumOfLogs sumOfLogs = new SumOfLogs();
        SumOfLogs.copy(this, sumOfLogs);
        return sumOfLogs;
    }

    public static void copy(SumOfLogs sumOfLogs, SumOfLogs sumOfLogs2) throws NullArgumentException {
        MathUtils.checkNotNull(sumOfLogs);
        MathUtils.checkNotNull(sumOfLogs2);
        sumOfLogs2.n = sumOfLogs.n;
        sumOfLogs2.value = sumOfLogs.value;
    }
}

