/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.LanczosApproximation;
import org.apache.commons.numbers.gamma.RegularizedGamma;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterMarsagliaTsangGammaSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;

public class GammaDistribution
extends AbstractContinuousDistribution {
    private static final double LANCZOS_G = LanczosApproximation.g();
    private final double shape;
    private final double scale;
    private final double shiftedShape;
    private final double densityPrefactor1;
    private final double logDensityPrefactor1;
    private final double densityPrefactor2;
    private final double logDensityPrefactor2;
    private final double minY;
    private final double maxLogY;

    public GammaDistribution(double d, double d2) {
        if (d <= 0.0) {
            throw new DistributionException("Number {0} is negative", d);
        }
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.shape = d;
        this.scale = d2;
        this.shiftedShape = d + LANCZOS_G + 0.5;
        double d3 = Math.E / (Math.PI * 2 * this.shiftedShape);
        this.densityPrefactor2 = d * Math.sqrt(d3) / LanczosApproximation.value(d);
        this.logDensityPrefactor2 = Math.log(d) + 0.5 * Math.log(d3) - Math.log(LanczosApproximation.value(d));
        this.densityPrefactor1 = this.densityPrefactor2 / d2 * Math.pow(this.shiftedShape, -d) * Math.exp(d + LANCZOS_G);
        this.logDensityPrefactor1 = this.logDensityPrefactor2 - Math.log(d2) - Math.log(this.shiftedShape) * d + d + LANCZOS_G;
        this.minY = d + LANCZOS_G - Math.log(Double.MAX_VALUE);
        this.maxLogY = Math.log(Double.MAX_VALUE) / (d - 1.0);
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        double d2 = d / this.scale;
        if (d2 <= this.minY || Math.log(d2) >= this.maxLogY) {
            double d3 = (d2 - this.shiftedShape) / this.shiftedShape;
            double d4 = this.shape * (Math.log1p(d3) - d3);
            double d5 = -d2 * (LANCZOS_G + 0.5) / this.shiftedShape + LANCZOS_G + d4;
            return this.densityPrefactor2 / d * Math.exp(d5);
        }
        return this.densityPrefactor1 * Math.exp(-d2) * Math.pow(d2, this.shape - 1.0);
    }

    @Override
    public double logDensity(double d) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = d / this.scale;
        if (d2 <= this.minY || Math.log(d2) >= this.maxLogY) {
            double d3 = (d2 - this.shiftedShape) / this.shiftedShape;
            double d4 = this.shape * (Math.log1p(d3) - d3);
            double d5 = -d2 * (LANCZOS_G + 0.5) / this.shiftedShape + LANCZOS_G + d4;
            return this.logDensityPrefactor2 - Math.log(d) + d5;
        }
        return this.logDensityPrefactor1 - d2 + Math.log(d2) * (this.shape - 1.0);
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = d <= 0.0 ? 0.0 : RegularizedGamma.P.value(this.shape, d / this.scale);
        return d2;
    }

    @Override
    public double getMean() {
        return this.shape * this.scale;
    }

    @Override
    public double getVariance() {
        return this.shape * this.scale * this.scale;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new AhrensDieterMarsagliaTsangGammaSampler(uniformRandomProvider, GammaDistribution.this.scale, GammaDistribution.this.shape);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

