/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.inference;

import io.virtdata.shaded.oac.statistics.distribution.BinomialDistribution;
import io.virtdata.shaded.oac.statistics.inference.AlternativeHypothesis;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.LocalizedFormats;

public class BinomialTest {
    public boolean binomialTest(int n, int n2, double d, AlternativeHypothesis alternativeHypothesis, double d2) {
        double d3 = this.binomialTest(n, n2, d, alternativeHypothesis);
        return d3 < d2;
    }

    public double binomialTest(int n, int n2, double d, AlternativeHypothesis alternativeHypothesis) {
        if (n < 0) {
            throw new NotPositiveException(n);
        }
        if (n2 < 0) {
            throw new NotPositiveException(n2);
        }
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        if (n < n2) {
            throw new MathIllegalArgumentException(LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, n, n2);
        }
        if (alternativeHypothesis == null) {
            throw new NullArgumentException();
        }
        BinomialDistribution binomialDistribution = new BinomialDistribution(n, d);
        switch (alternativeHypothesis) {
            case GREATER_THAN: {
                return 1.0 - binomialDistribution.cumulativeProbability(n2 - 1);
            }
            case LESS_THAN: {
                return binomialDistribution.cumulativeProbability(n2);
            }
            case TWO_SIDED: {
                int n3 = 0;
                int n4 = n;
                double d2 = 0.0;
                do {
                    double d3;
                    double d4;
                    if ((d4 = binomialDistribution.probability(n3)) == (d3 = binomialDistribution.probability(n4))) {
                        d2 = n3 == n4 ? (d2 += d4) : (d2 += 2.0 * d4);
                        ++n3;
                        --n4;
                        continue;
                    }
                    if (d4 < d3) {
                        d2 += d4;
                        ++n3;
                        continue;
                    }
                    d2 += d3;
                    --n4;
                } while (n3 <= n2 && n4 >= n2);
                return d2;
            }
        }
        throw new MathInternalError(LocalizedFormats.OUT_OF_RANGE_SIMPLE, new Object[]{alternativeHypothesis, AlternativeHypothesis.TWO_SIDED, AlternativeHypothesis.LESS_THAN});
    }
}

