/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.interval;

import io.virtdata.shaded.oac.statistics.distribution.FDistribution;
import io.virtdata.shaded.oac.statistics.interval.BinomialConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.ConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.IntervalUtils;

public class ClopperPearsonInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int n, int n2, double d) {
        IntervalUtils.checkParameters(n, n2, d);
        double d2 = 0.0;
        double d3 = 0.0;
        if (n2 > 0) {
            double d4 = 0.5 * (1.0 - d);
            FDistribution fDistribution = new FDistribution(2 * (n - n2 + 1), 2 * n2);
            double d5 = fDistribution.inverseCumulativeProbability(1.0 - d4);
            d2 = (double)n2 / ((double)n2 + (double)(n - n2 + 1) * d5);
            if (n2 != n) {
                FDistribution fDistribution2 = new FDistribution(2 * (n2 + 1), 2 * (n - n2));
                double d6 = fDistribution2.inverseCumulativeProbability(1.0 - d4);
                d3 = (double)(n2 + 1) * d6 / ((double)(n - n2) + (double)(n2 + 1) * d6);
            } else {
                d3 = 1.0;
            }
        }
        return new ConfidenceInterval(d2, d3, d);
    }
}

