/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.interval;

import io.virtdata.shaded.oac.statistics.interval.AgrestiCoullInterval;
import io.virtdata.shaded.oac.statistics.interval.BinomialConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.ClopperPearsonInterval;
import io.virtdata.shaded.oac.statistics.interval.ConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.NormalApproximationInterval;
import io.virtdata.shaded.oac.statistics.interval.WilsonScoreInterval;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;

public final class IntervalUtils {
    private static final BinomialConfidenceInterval AGRESTI_COULL = new AgrestiCoullInterval();
    private static final BinomialConfidenceInterval CLOPPER_PEARSON = new ClopperPearsonInterval();
    private static final BinomialConfidenceInterval NORMAL_APPROXIMATION = new NormalApproximationInterval();
    private static final BinomialConfidenceInterval WILSON_SCORE = new WilsonScoreInterval();

    private IntervalUtils() {
    }

    public static ConfidenceInterval getAgrestiCoullInterval(int n, int n2, double d) {
        return AGRESTI_COULL.createInterval(n, n2, d);
    }

    public static ConfidenceInterval getClopperPearsonInterval(int n, int n2, double d) {
        return CLOPPER_PEARSON.createInterval(n, n2, d);
    }

    public static ConfidenceInterval getNormalApproximationInterval(int n, int n2, double d) {
        return NORMAL_APPROXIMATION.createInterval(n, n2, d);
    }

    public static ConfidenceInterval getWilsonScoreInterval(int n, int n2, double d) {
        return WILSON_SCORE.createInterval(n, n2, d);
    }

    static void checkParameters(int n, int n2, double d) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_TRIALS, n);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NEGATIVE_NUMBER_OF_SUCCESSES, n2);
        }
        if (n2 > n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE, (Number)n2, n, true);
        }
        if (d <= 0.0 || d >= 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_CONFIDENCE_LEVEL, (Number)d, 0, 1);
        }
    }
}

