/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration;

import org.apache.commons.math4.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math4.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.util.FastMath;

public class SimpsonIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int SIMPSON_MAX_ITERATIONS_COUNT = 63;

    public SimpsonIntegrator(double d, double d2, int n, int n2) throws NotStrictlyPositiveException, NumberIsTooSmallException, NumberIsTooLargeException {
        super(d, d2, n, n2);
        if (n2 > 63) {
            throw new NumberIsTooLargeException(n2, (Number)63, false);
        }
    }

    public SimpsonIntegrator(int n, int n2) throws NotStrictlyPositiveException, NumberIsTooSmallException, NumberIsTooLargeException {
        super(n, n2);
        if (n2 > 63) {
            throw new NumberIsTooLargeException(n2, (Number)63, false);
        }
    }

    public SimpsonIntegrator() {
        super(3, 63);
    }

    @Override
    protected double doIntegrate() {
        TrapezoidIntegrator trapezoidIntegrator = new TrapezoidIntegrator();
        double d = trapezoidIntegrator.stage(this, 0);
        double d2 = trapezoidIntegrator.stage(this, 1);
        double d3 = (4.0 * d2 - d) / 3.0;
        while (true) {
            double d4;
            double d5;
            this.iterations.incrementCount();
            int n = this.getIterations();
            double d6 = trapezoidIntegrator.stage(this, n + 1);
            double d7 = (4.0 * d6 - d2) / 3.0;
            if (n >= this.getMinimalIterationCount() && ((d5 = FastMath.abs(d7 - d3)) <= (d4 = this.getRelativeAccuracy() * (FastMath.abs(d3) + FastMath.abs(d7)) * 0.5) || d5 <= this.getAbsoluteAccuracy())) {
                return d7;
            }
            d3 = d7;
            d2 = d6;
        }
    }
}

