/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.interpolation;

import org.apache.commons.math4.analysis.TrivariateFunction;
import org.apache.commons.math4.exception.OutOfRangeException;

class TricubicFunction
implements TrivariateFunction {
    private static final short N = 4;
    private final double[][][] a = new double[4][4][4];

    TricubicFunction(double[] dArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.a[i][j][k] = dArray[i + 4 * (j + 4 * k)];
                }
            }
        }
    }

    @Override
    public double value(double d, double d2, double d3) throws OutOfRangeException {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new OutOfRangeException(d3, (Number)0, 1);
        }
        double d4 = d * d;
        double d5 = d4 * d;
        double[] dArray = new double[]{1.0, d, d4, d5};
        double d6 = d2 * d2;
        double d7 = d6 * d2;
        double[] dArray2 = new double[]{1.0, d2, d6, d7};
        double d8 = d3 * d3;
        double d9 = d8 * d3;
        double[] dArray3 = new double[]{1.0, d3, d8, d9};
        double d10 = 0.0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    d10 += this.a[i][j][k] * dArray[i] * dArray2[j] * dArray3[k];
                }
            }
        }
        return d10;
    }
}

