/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.solvers;

import org.apache.commons.math4.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math4.exception.NoBracketingException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.TooManyEvaluationsException;
import org.apache.commons.math4.util.FastMath;

public class MullerSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public MullerSolver() {
        this(1.0E-6);
    }

    public MullerSolver(double d) {
        super(d);
    }

    public MullerSolver(double d, double d2) {
        super(d, d2);
    }

    @Override
    protected double doSolve() throws TooManyEvaluationsException, NumberIsTooLargeException, NoBracketingException {
        double d = this.getMin();
        double d2 = this.getMax();
        double d3 = this.getStartValue();
        double d4 = this.getFunctionValueAccuracy();
        this.verifySequence(d, d3, d2);
        double d5 = this.computeObjectiveValue(d);
        if (FastMath.abs(d5) < d4) {
            return d;
        }
        double d6 = this.computeObjectiveValue(d2);
        if (FastMath.abs(d6) < d4) {
            return d2;
        }
        double d7 = this.computeObjectiveValue(d3);
        if (FastMath.abs(d7) < d4) {
            return d3;
        }
        this.verifyBracketing(d, d2);
        if (this.isBracketing(d, d3)) {
            return this.solve(d, d3, d5, d7);
        }
        return this.solve(d3, d2, d7, d6);
    }

    private double solve(double d, double d2, double d3, double d4) throws TooManyEvaluationsException {
        double d5 = this.getRelativeAccuracy();
        double d6 = this.getAbsoluteAccuracy();
        double d7 = this.getFunctionValueAccuracy();
        double d8 = d;
        double d9 = d3;
        double d10 = d2;
        double d11 = d4;
        double d12 = 0.5 * (d8 + d10);
        double d13 = this.computeObjectiveValue(d12);
        double d14 = Double.POSITIVE_INFINITY;
        while (true) {
            boolean bl;
            double d15 = (d13 - d9) / (d12 - d8);
            double d16 = (d11 - d13) / (d10 - d12);
            double d17 = (d16 - d15) / (d10 - d8);
            double d18 = d15 + (d12 - d8) * d17;
            double d19 = d18 * d18 - 4.0 * d13 * d17;
            double d20 = d12 + -2.0 * d13 / (d18 + FastMath.sqrt(d19));
            double d21 = d12 + -2.0 * d13 / (d18 - FastMath.sqrt(d19));
            double d22 = this.isSequence(d8, d20, d10) ? d20 : d21;
            double d23 = this.computeObjectiveValue(d22);
            double d24 = FastMath.max(d5 * FastMath.abs(d22), d6);
            if (FastMath.abs(d22 - d14) <= d24 || FastMath.abs(d23) <= d7) {
                return d22;
            }
            boolean bl2 = bl = d22 < d12 && d12 - d8 > 0.95 * (d10 - d8) || d22 > d12 && d10 - d12 > 0.95 * (d10 - d8) || d22 == d12;
            if (!bl) {
                d8 = d22 < d12 ? d8 : d12;
                d9 = d22 < d12 ? d9 : d13;
                d10 = d22 > d12 ? d10 : d12;
                d11 = d22 > d12 ? d11 : d13;
                d12 = d22;
                d13 = d23;
                d14 = d22;
                continue;
            }
            double d25 = 0.5 * (d8 + d10);
            double d26 = this.computeObjectiveValue(d25);
            if (FastMath.signum(d9) + FastMath.signum(d26) == 0.0) {
                d10 = d25;
                d11 = d26;
            } else {
                d8 = d25;
                d9 = d26;
            }
            d12 = 0.5 * (d8 + d10);
            d13 = this.computeObjectiveValue(d12);
            d14 = Double.POSITIVE_INFINITY;
        }
    }
}

