/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math4.distribution.AbstractIntegerDistribution;
import org.apache.commons.math4.distribution.EnumeratedDistribution;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NotANumberException;
import org.apache.commons.math4.exception.NotFiniteNumberException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.util.Pair;
import org.apache.commons.rng.UniformRandomProvider;

public class EnumeratedIntegerDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20130308L;
    protected final EnumeratedDistribution<Integer> innerDistribution;

    public EnumeratedIntegerDistribution(int[] nArray, double[] dArray) throws DimensionMismatchException, NotPositiveException, MathArithmeticException, NotFiniteNumberException, NotANumberException {
        this.innerDistribution = new EnumeratedDistribution(EnumeratedIntegerDistribution.createDistribution(nArray, dArray));
    }

    public EnumeratedIntegerDistribution(int[] nArray) {
        Object object;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int n : nArray) {
            object = (Integer)hashMap.get(n);
            if (object == null) {
                object = 0;
            }
            object = (Integer)object + 1;
            hashMap.put(n, (Integer)object);
        }
        int n = hashMap.size();
        double d = nArray.length;
        int[] nArray2 = new int[n];
        object = new double[n];
        int n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            nArray2[n2] = (Integer)entry.getKey();
            object[n2] = (double)((Integer)entry.getValue()).intValue() / d;
            ++n2;
        }
        this.innerDistribution = new EnumeratedDistribution(EnumeratedIntegerDistribution.createDistribution(nArray2, (double[])object));
    }

    private static List<Pair<Integer, Double>> createDistribution(int[] nArray, double[] dArray) {
        if (nArray.length != dArray.length) {
            throw new DimensionMismatchException(dArray.length, nArray.length);
        }
        ArrayList<Pair<Integer, Double>> arrayList = new ArrayList<Pair<Integer, Double>>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Pair<Integer, Double>(nArray[i], dArray[i]));
        }
        return arrayList;
    }

    @Override
    public double probability(int n) {
        return this.innerDistribution.probability(n);
    }

    @Override
    public double cumulativeProbability(int n) {
        double d = 0.0;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            if (pair.getKey() > n) continue;
            d += pair.getValue().doubleValue();
        }
        return d;
    }

    @Override
    public double getMean() {
        double d = 0.0;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            d += pair.getValue() * (double)pair.getKey().intValue();
        }
        return d;
    }

    @Override
    public double getVariance() {
        double d = 0.0;
        double d2 = 0.0;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            d += pair.getValue() * (double)pair.getKey().intValue();
            d2 += pair.getValue() * (double)pair.getKey().intValue() * (double)pair.getKey().intValue();
        }
        return d2 - d * d;
    }

    @Override
    public int getSupportLowerBound() {
        int n = Integer.MAX_VALUE;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            if (pair.getKey() >= n || !(pair.getValue() > 0.0)) continue;
            n = pair.getKey();
        }
        return n;
    }

    @Override
    public int getSupportUpperBound() {
        int n = Integer.MIN_VALUE;
        for (Pair<Integer, Double> pair : this.innerDistribution.getPmf()) {
            if (pair.getKey() <= n || !(pair.getValue() > 0.0)) continue;
            n = pair.getKey();
        }
        return n;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new DiscreteDistribution.Sampler(){
            private final EnumeratedDistribution.Sampler inner;
            {
                this.inner = EnumeratedIntegerDistribution.this.innerDistribution.createSampler(uniformRandomProvider);
            }

            @Override
            public int sample() {
                return (Integer)this.inner.sample();
            }
        };
    }
}

