/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.util.Arrays;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.NonSquareMatrixException;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.util.FastMath;

class TriDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedQ;
    private RealMatrix cachedQt;
    private RealMatrix cachedT;

    TriDiagonalTransformer(RealMatrix realMatrix) {
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n = realMatrix.getRowDimension();
        this.householderVectors = realMatrix.getData();
        this.main = new double[n];
        this.secondary = new double[n - 1];
        this.cachedQ = null;
        this.cachedQt = null;
        this.cachedT = null;
        this.transform();
    }

    public RealMatrix getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public RealMatrix getQT() {
        if (this.cachedQt == null) {
            int n = this.householderVectors.length;
            double[][] dArray = new double[n][n];
            for (int i = n - 1; i >= 1; --i) {
                int n2;
                double[] dArray2 = this.householderVectors[i - 1];
                dArray[i][i] = 1.0;
                if (dArray2[i] == 0.0) continue;
                double d = 1.0 / (this.secondary[i - 1] * dArray2[i]);
                double d2 = 1.0 / this.secondary[i - 1];
                dArray[i][i] = 1.0 + d2 * dArray2[i];
                for (n2 = i + 1; n2 < n; ++n2) {
                    dArray[i][n2] = d2 * dArray2[n2];
                }
                for (n2 = i + 1; n2 < n; ++n2) {
                    int n3;
                    d2 = 0.0;
                    for (n3 = i + 1; n3 < n; ++n3) {
                        d2 += dArray[n2][n3] * dArray2[n3];
                    }
                    dArray[n2][i] = (d2 *= d) * dArray2[i];
                    for (n3 = i + 1; n3 < n; ++n3) {
                        double[] dArray3 = dArray[n2];
                        int n4 = n3;
                        dArray3[n4] = dArray3[n4] + d2 * dArray2[n3];
                    }
                }
            }
            dArray[0][0] = 1.0;
            this.cachedQt = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedQt;
    }

    public RealMatrix getT() {
        if (this.cachedT == null) {
            int n = this.main.length;
            double[][] dArray = new double[n][n];
            for (int i = 0; i < n; ++i) {
                dArray[i][i] = this.main[i];
                if (i > 0) {
                    dArray[i][i - 1] = this.secondary[i - 1];
                }
                if (i >= this.main.length - 1) continue;
                dArray[i][i + 1] = this.secondary[i];
            }
            this.cachedT = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedT;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    private void transform() {
        int n = this.householderVectors.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n - 1; ++i) {
            int n2;
            double d;
            double[] dArray2 = this.householderVectors[i];
            this.main[i] = dArray2[i];
            double d2 = 0.0;
            for (int j = i + 1; j < n; ++j) {
                double d3 = dArray2[j];
                d2 += d3 * d3;
            }
            this.secondary[i] = d = dArray2[i + 1] > 0.0 ? -FastMath.sqrt(d2) : FastMath.sqrt(d2);
            if (d == 0.0) continue;
            int n3 = i + 1;
            dArray2[n3] = dArray2[n3] - d;
            double d4 = -1.0 / (d * dArray2[i + 1]);
            Arrays.fill(dArray, i + 1, n, 0.0);
            for (int j = i + 1; j < n; ++j) {
                double[] dArray3 = this.householderVectors[j];
                double d5 = dArray2[j];
                double d6 = dArray3[j] * d5;
                int n4 = j + 1;
                while (n4 < n) {
                    double d7 = dArray3[n4];
                    d6 += d7 * dArray2[n4];
                    int n5 = n4++;
                    dArray[n5] = dArray[n5] + d7 * d5;
                }
                dArray[j] = d4 * (dArray[j] + d6);
            }
            double d8 = 0.0;
            for (n2 = i + 1; n2 < n; ++n2) {
                d8 += dArray[n2] * dArray2[n2];
            }
            d8 *= d4 / 2.0;
            for (n2 = i + 1; n2 < n; ++n2) {
                int n6 = n2;
                dArray[n6] = dArray[n6] - d8 * dArray2[n2];
            }
            for (n2 = i + 1; n2 < n; ++n2) {
                double[] dArray4 = this.householderVectors[n2];
                for (int j = n2; j < n; ++j) {
                    int n7 = j;
                    dArray4[n7] = dArray4[n7] - (dArray2[n2] * dArray[j] + dArray[n2] * dArray2[j]);
                }
            }
        }
        this.main[n - 1] = this.householderVectors[n - 1][n - 1];
    }
}

