/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.apache.commons.numbers.fraction.Fraction;
import org.apache.commons.numbers.fraction.FractionFormat;

public class ProperFractionFormat
extends FractionFormat {
    private static final long serialVersionUID = 760934726031766749L;
    private NumberFormat wholeFormat;

    public ProperFractionFormat() {
        this(ProperFractionFormat.getDefaultNumberFormat());
    }

    public ProperFractionFormat(NumberFormat numberFormat) {
        this(numberFormat, (NumberFormat)numberFormat.clone(), (NumberFormat)numberFormat.clone());
    }

    public ProperFractionFormat(NumberFormat numberFormat, NumberFormat numberFormat2, NumberFormat numberFormat3) {
        super(numberFormat2, numberFormat3);
        this.setWholeFormat(numberFormat);
    }

    @Override
    public StringBuffer format(Fraction fraction, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        int n = fraction.getNumerator();
        int n2 = fraction.getDenominator();
        int n3 = n / n2;
        n %= n2;
        if (n3 != 0) {
            this.getWholeFormat().format(n3, stringBuffer, fieldPosition);
            stringBuffer.append(' ');
            n = Math.abs(n);
        }
        this.getNumeratorFormat().format(n, stringBuffer, fieldPosition);
        stringBuffer.append(" / ");
        this.getDenominatorFormat().format(n2, stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public NumberFormat getWholeFormat() {
        return this.wholeFormat;
    }

    @Override
    public Fraction parse(String string, ParsePosition parsePosition) {
        Fraction fraction = super.parse(string, parsePosition);
        if (fraction != null) {
            return fraction;
        }
        int n = parsePosition.getIndex();
        ProperFractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        Number number = this.getWholeFormat().parse(string, parsePosition);
        if (number == null) {
            parsePosition.setIndex(n);
            return null;
        }
        ProperFractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        Number number2 = this.getNumeratorFormat().parse(string, parsePosition);
        if (number2 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (number2.intValue() < 0) {
            parsePosition.setIndex(n);
            return null;
        }
        int n2 = parsePosition.getIndex();
        char c = ProperFractionFormat.parseNextCharacter(string, parsePosition);
        switch (c) {
            case '\u0000': {
                return new Fraction(number2.intValue(), 1);
            }
            case '/': {
                break;
            }
            default: {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        ProperFractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        Number number3 = this.getDenominatorFormat().parse(string, parsePosition);
        if (number3 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        if (number3.intValue() < 0) {
            parsePosition.setIndex(n);
            return null;
        }
        int n3 = number.intValue();
        int n4 = n3 >= 0 ? 1 : -1;
        int n5 = number2.intValue();
        int n6 = number3.intValue();
        return new Fraction((Math.abs(n3) * n6 + n5) * n4, n6);
    }

    public void setWholeFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullPointerException("whole format");
        }
        this.wholeFormat = numberFormat;
    }
}

