/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.correlation;

import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;

class StorelessBivariateCovariance {
    private double meanX = 0.0;
    private double meanY = 0.0;
    private double n = 0.0;
    private double covarianceNumerator = 0.0;
    private boolean biasCorrected;

    StorelessBivariateCovariance() {
        this(true);
    }

    StorelessBivariateCovariance(boolean bl) {
        this.biasCorrected = bl;
    }

    public void increment(double d, double d2) {
        this.n += 1.0;
        double d3 = d - this.meanX;
        double d4 = d2 - this.meanY;
        this.meanX += d3 / this.n;
        this.meanY += d4 / this.n;
        this.covarianceNumerator += (this.n - 1.0) / this.n * d3 * d4;
    }

    public void append(StorelessBivariateCovariance storelessBivariateCovariance) {
        double d = this.n;
        this.n += storelessBivariateCovariance.n;
        double d2 = storelessBivariateCovariance.meanX - this.meanX;
        double d3 = storelessBivariateCovariance.meanY - this.meanY;
        this.meanX += d2 * storelessBivariateCovariance.n / this.n;
        this.meanY += d3 * storelessBivariateCovariance.n / this.n;
        this.covarianceNumerator += storelessBivariateCovariance.covarianceNumerator + d * storelessBivariateCovariance.n / this.n * d2 * d3;
    }

    public double getN() {
        return this.n;
    }

    public double getResult() throws NumberIsTooSmallException {
        if (this.n < 2.0) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_DIMENSION, (Number)this.n, 2, true);
        }
        if (this.biasCorrected) {
            return this.covarianceNumerator / (this.n - 1.0);
        }
        return this.covarianceNumerator / this.n;
    }
}

