/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.inference;

import io.virtdata.shaded.oac.statistics.distribution.NormalDistribution;
import io.virtdata.shaded.oac.statistics.ranking.NaNStrategy;
import io.virtdata.shaded.oac.statistics.ranking.NaturalRanking;
import io.virtdata.shaded.oac.statistics.ranking.TiesStrategy;
import org.apache.commons.math4.exception.ConvergenceException;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.FastMath;

public class MannWhitneyUTest {
    private NaturalRanking naturalRanking;

    public MannWhitneyUTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public MannWhitneyUTest(NaNStrategy naNStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(naNStrategy, tiesStrategy);
    }

    private void ensureDataConformance(double[] dArray, double[] dArray2) throws NullArgumentException, NoDataException {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            throw new NoDataException();
        }
    }

    private double[] concatenateSamples(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return dArray3;
    }

    public double mannWhitneyU(double[] dArray, double[] dArray2) throws NullArgumentException, NoDataException {
        this.ensureDataConformance(dArray, dArray2);
        double[] dArray3 = this.concatenateSamples(dArray, dArray2);
        double[] dArray4 = this.naturalRanking.rank(dArray3);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray4[i];
        }
        double d2 = d - (double)((long)dArray.length * (long)(dArray.length + 1) / 2L);
        double d3 = (double)((long)dArray.length * (long)dArray2.length) - d2;
        return FastMath.max(d2, d3);
    }

    private double calculateAsymptoticPValue(double d, int n, int n2) throws ConvergenceException, MaxCountExceededException {
        long l = (long)n * (long)n2;
        double d2 = (double)l / 2.0;
        double d3 = (double)(l * (long)(n + n2 + 1)) / 12.0;
        double d4 = (d - d2) / FastMath.sqrt(d3);
        NormalDistribution normalDistribution = new NormalDistribution(0.0, 1.0);
        return 2.0 * normalDistribution.cumulativeProbability(d4);
    }

    public double mannWhitneyUTest(double[] dArray, double[] dArray2) throws NullArgumentException, NoDataException, ConvergenceException, MaxCountExceededException {
        this.ensureDataConformance(dArray, dArray2);
        double d = this.mannWhitneyU(dArray, dArray2);
        double d2 = (double)((long)dArray.length * (long)dArray2.length) - d;
        return this.calculateAsymptoticPValue(d2, dArray.length, dArray2.length);
    }
}

