/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.MultivariateRealDistribution;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.rng.UniformRandomProvider;

public abstract class AbstractMultivariateRealDistribution
implements MultivariateRealDistribution {
    private final int dimension;

    protected AbstractMultivariateRealDistribution(int n) {
        this.dimension = n;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public abstract MultivariateRealDistribution.Sampler createSampler(UniformRandomProvider var1);

    public static double[][] sample(int n, MultivariateRealDistribution.Sampler sampler) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = sampler.sample();
        }
        return dArrayArray;
    }
}

