/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import io.virtdata.shaded.oac.statistics.descriptive.StatisticalSummary;
import io.virtdata.shaded.oac.statistics.descriptive.SummaryStatistics;
import io.virtdata.shaded.oac.statistics.distribution.ConstantContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.NormalDistribution;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.distribution.AbstractRealDistribution;
import org.apache.commons.math4.exception.MathIllegalStateException;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.ZeroException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.rng.UniformRandomProvider;

public class EmpiricalDistribution
extends AbstractRealDistribution
implements ContinuousDistribution {
    public static final int DEFAULT_BIN_COUNT = 1000;
    private static final String FILE_CHARSET = "US-ASCII";
    private static final long serialVersionUID = 5729073523949762654L;
    private final List<SummaryStatistics> binStats;
    private SummaryStatistics sampleStats = null;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double delta = 0.0;
    private final int binCount;
    private boolean loaded = false;
    private double[] upperBounds = null;

    public EmpiricalDistribution() {
        this(1000);
    }

    public EmpiricalDistribution(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.binCount = n;
        this.binStats = new ArrayList<SummaryStatistics>();
    }

    public void load(double[] dArray) throws NullArgumentException {
        ArrayDataAdapter arrayDataAdapter = new ArrayDataAdapter(dArray);
        try {
            ((DataAdapter)arrayDataAdapter).computeStats();
            this.fillBinStats(new ArrayDataAdapter(dArray));
        }
        catch (IOException iOException) {
            throw new MathInternalError();
        }
        this.loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL uRL) throws IOException, NullArgumentException, ZeroException {
        MathUtils.checkNotNull(uRL);
        Charset charset = Charset.forName(FILE_CHARSET);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), charset));
        try {
            StreamDataAdapter streamDataAdapter = new StreamDataAdapter(bufferedReader);
            ((DataAdapter)streamDataAdapter).computeStats();
            if (this.sampleStats.getN() == 0L) {
                throw new ZeroException((Localizable)LocalizedFormats.URL_CONTAINS_NO_DATA, uRL);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), charset));
            this.fillBinStats(new StreamDataAdapter(bufferedReader));
            this.loaded = true;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException, NullArgumentException {
        MathUtils.checkNotNull(file);
        Charset charset = Charset.forName(FILE_CHARSET);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, charset));
        try {
            StreamDataAdapter streamDataAdapter = new StreamDataAdapter(bufferedReader);
            ((DataAdapter)streamDataAdapter).computeStats();
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, charset));
            this.fillBinStats(new StreamDataAdapter(bufferedReader));
            this.loaded = true;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void fillBinStats(DataAdapter dataAdapter) throws IOException {
        int n;
        this.min = this.sampleStats.getMin();
        this.max = this.sampleStats.getMax();
        this.delta = (this.max - this.min) / (double)this.binCount;
        if (!this.binStats.isEmpty()) {
            this.binStats.clear();
        }
        for (n = 0; n < this.binCount; ++n) {
            SummaryStatistics summaryStatistics = new SummaryStatistics();
            this.binStats.add(n, summaryStatistics);
        }
        dataAdapter.computeBinStats();
        this.upperBounds = new double[this.binCount];
        this.upperBounds[0] = (double)this.binStats.get(0).getN() / (double)this.sampleStats.getN();
        for (n = 1; n < this.binCount - 1; ++n) {
            this.upperBounds[n] = this.upperBounds[n - 1] + (double)this.binStats.get(n).getN() / (double)this.sampleStats.getN();
        }
        this.upperBounds[this.binCount - 1] = 1.0;
    }

    private int findBin(double d) {
        return FastMath.min(FastMath.max((int)FastMath.ceil((d - this.min) / this.delta) - 1, 0), this.binCount - 1);
    }

    public StatisticalSummary getSampleStats() {
        return this.sampleStats;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public List<SummaryStatistics> getBinStats() {
        return this.binStats;
    }

    public double[] getUpperBounds() {
        double[] dArray = new double[this.binCount];
        for (int i = 0; i < this.binCount - 1; ++i) {
            dArray[i] = this.min + this.delta * (double)(i + 1);
        }
        dArray[this.binCount - 1] = this.max;
        return dArray;
    }

    public double[] getGeneratorUpperBounds() {
        int n = this.upperBounds.length;
        double[] dArray = new double[n];
        System.arraycopy(this.upperBounds, 0, dArray, 0, n);
        return dArray;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public double probability(double d) {
        return 0.0;
    }

    @Override
    public double density(double d) {
        if (d < this.min || d > this.max) {
            return 0.0;
        }
        int n = this.findBin(d);
        ContinuousDistribution continuousDistribution = this.getKernel(this.binStats.get(n));
        return continuousDistribution.density(d) * this.pB(n) / this.kB(n);
    }

    @Override
    public double cumulativeProbability(double d) {
        if (d < this.min) {
            return 0.0;
        }
        if (d >= this.max) {
            return 1.0;
        }
        int n = this.findBin(d);
        double d2 = this.pBminus(n);
        double d3 = this.pB(n);
        ContinuousDistribution continuousDistribution = this.k(d);
        if (continuousDistribution instanceof ConstantContinuousDistribution) {
            if (d < continuousDistribution.getMean()) {
                return d2;
            }
            return d2 + d3;
        }
        double[] dArray = this.getUpperBounds();
        double d4 = this.kB(n);
        double d5 = n == 0 ? this.min : dArray[n - 1];
        double d6 = (continuousDistribution.cumulativeProbability(d) - continuousDistribution.cumulativeProbability(d5)) / d4;
        return d2 + d3 * d6;
    }

    @Override
    public double inverseCumulativeProbability(double d) throws OutOfRangeException {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        if (d == 0.0) {
            return this.getSupportLowerBound();
        }
        if (d == 1.0) {
            return this.getSupportUpperBound();
        }
        int n = 0;
        while (this.cumBinP(n) < d) {
            ++n;
        }
        ContinuousDistribution continuousDistribution = this.getKernel(this.binStats.get(n));
        double d2 = this.kB(n);
        double[] dArray = this.getUpperBounds();
        double d3 = n == 0 ? this.min : dArray[n - 1];
        double d4 = continuousDistribution.cumulativeProbability(d3);
        double d5 = this.pB(n);
        double d6 = this.pBminus(n);
        double d7 = d - d6;
        if (d7 <= 0.0) {
            return d3;
        }
        return continuousDistribution.inverseCumulativeProbability(d4 + d7 * d2 / d5);
    }

    @Override
    public double getMean() {
        return this.sampleStats.getMean();
    }

    @Override
    public double getVariance() {
        return this.sampleStats.getVariance();
    }

    @Override
    public double getSupportLowerBound() {
        return this.min;
    }

    @Override
    public double getSupportUpperBound() {
        return this.max;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider uniformRandomProvider) {
        if (!this.loaded) {
            throw new MathIllegalStateException(LocalizedFormats.DISTRIBUTION_NOT_LOADED, new Object[0]);
        }
        return super.createSampler(uniformRandomProvider);
    }

    private double pB(int n) {
        return n == 0 ? this.upperBounds[0] : this.upperBounds[n] - this.upperBounds[n - 1];
    }

    private double pBminus(int n) {
        return n == 0 ? 0.0 : this.upperBounds[n - 1];
    }

    private double kB(int n) {
        double[] dArray = this.getUpperBounds();
        ContinuousDistribution continuousDistribution = this.getKernel(this.binStats.get(n));
        return n == 0 ? continuousDistribution.probability(this.min, dArray[0]) : continuousDistribution.probability(dArray[n - 1], dArray[n]);
    }

    private ContinuousDistribution k(double d) {
        int n = this.findBin(d);
        return this.getKernel(this.binStats.get(n));
    }

    private double cumBinP(int n) {
        return this.upperBounds[n];
    }

    protected ContinuousDistribution getKernel(SummaryStatistics summaryStatistics) {
        if (summaryStatistics.getN() == 1L || summaryStatistics.getVariance() == 0.0) {
            return new ConstantContinuousDistribution(summaryStatistics.getMean());
        }
        return new NormalDistribution(summaryStatistics.getMean(), summaryStatistics.getStandardDeviation());
    }

    private class ArrayDataAdapter
    extends DataAdapter {
        private final double[] inputArray;

        ArrayDataAdapter(double[] dArray) throws NullArgumentException {
            MathUtils.checkNotNull(dArray);
            this.inputArray = dArray;
        }

        @Override
        public void computeStats() throws IOException {
            EmpiricalDistribution.this.sampleStats = new SummaryStatistics();
            for (int i = 0; i < this.inputArray.length; ++i) {
                EmpiricalDistribution.this.sampleStats.addValue(this.inputArray[i]);
            }
        }

        @Override
        public void computeBinStats() throws IOException {
            for (int i = 0; i < this.inputArray.length; ++i) {
                SummaryStatistics summaryStatistics = EmpiricalDistribution.this.binStats.get(EmpiricalDistribution.this.findBin(this.inputArray[i]));
                summaryStatistics.addValue(this.inputArray[i]);
            }
        }
    }

    private class StreamDataAdapter
    extends DataAdapter {
        private BufferedReader inputStream;

        StreamDataAdapter(BufferedReader bufferedReader) {
            this.inputStream = bufferedReader;
        }

        @Override
        public void computeBinStats() throws IOException {
            String string = null;
            double d = 0.0;
            while ((string = this.inputStream.readLine()) != null) {
                d = Double.parseDouble(string);
                SummaryStatistics summaryStatistics = EmpiricalDistribution.this.binStats.get(EmpiricalDistribution.this.findBin(d));
                summaryStatistics.addValue(d);
            }
            this.inputStream.close();
            this.inputStream = null;
        }

        @Override
        public void computeStats() throws IOException {
            String string = null;
            double d = 0.0;
            EmpiricalDistribution.this.sampleStats = new SummaryStatistics();
            while ((string = this.inputStream.readLine()) != null) {
                d = Double.parseDouble(string);
                EmpiricalDistribution.this.sampleStats.addValue(d);
            }
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    private abstract class DataAdapter {
        private DataAdapter() {
        }

        public abstract void computeBinStats() throws IOException;

        public abstract void computeStats() throws IOException;
    }
}

