/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.commons.math4.Field;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.BigRealField;

public class BigReal
implements FieldElement<BigReal>,
Comparable<BigReal>,
Serializable {
    public static final BigReal ZERO = new BigReal(BigDecimal.ZERO);
    public static final BigReal ONE = new BigReal(BigDecimal.ONE);
    private static final long serialVersionUID = 4984534880991310382L;
    private final BigDecimal d;
    private RoundingMode roundingMode = RoundingMode.HALF_UP;
    private int scale = 64;

    public BigReal(BigDecimal bigDecimal) {
        this.d = bigDecimal;
    }

    public BigReal(BigInteger bigInteger) {
        this.d = new BigDecimal(bigInteger);
    }

    public BigReal(BigInteger bigInteger, int n) {
        this.d = new BigDecimal(bigInteger, n);
    }

    public BigReal(BigInteger bigInteger, int n, MathContext mathContext) {
        this.d = new BigDecimal(bigInteger, n, mathContext);
    }

    public BigReal(BigInteger bigInteger, MathContext mathContext) {
        this.d = new BigDecimal(bigInteger, mathContext);
    }

    public BigReal(char[] cArray) {
        this.d = new BigDecimal(cArray);
    }

    public BigReal(char[] cArray, int n, int n2) {
        this.d = new BigDecimal(cArray, n, n2);
    }

    public BigReal(char[] cArray, int n, int n2, MathContext mathContext) {
        this.d = new BigDecimal(cArray, n, n2, mathContext);
    }

    public BigReal(char[] cArray, MathContext mathContext) {
        this.d = new BigDecimal(cArray, mathContext);
    }

    public BigReal(double d) {
        this.d = new BigDecimal(d);
    }

    public BigReal(double d, MathContext mathContext) {
        this.d = new BigDecimal(d, mathContext);
    }

    public BigReal(int n) {
        this.d = new BigDecimal(n);
    }

    public BigReal(int n, MathContext mathContext) {
        this.d = new BigDecimal(n, mathContext);
    }

    public BigReal(long l) {
        this.d = new BigDecimal(l);
    }

    public BigReal(long l, MathContext mathContext) {
        this.d = new BigDecimal(l, mathContext);
    }

    public BigReal(String string) {
        this.d = new BigDecimal(string);
    }

    public BigReal(String string, MathContext mathContext) {
        this.d = new BigDecimal(string, mathContext);
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    @Override
    public BigReal add(BigReal bigReal) {
        return new BigReal(this.d.add(bigReal.d));
    }

    @Override
    public BigReal subtract(BigReal bigReal) {
        return new BigReal(this.d.subtract(bigReal.d));
    }

    @Override
    public BigReal negate() {
        return new BigReal(this.d.negate());
    }

    @Override
    public BigReal divide(BigReal bigReal) throws MathArithmeticException {
        try {
            return new BigReal(this.d.divide(bigReal.d, this.scale, this.roundingMode));
        }
        catch (ArithmeticException arithmeticException) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NOT_ALLOWED, new Object[0]);
        }
    }

    @Override
    public BigReal reciprocal() throws MathArithmeticException {
        try {
            return new BigReal(BigDecimal.ONE.divide(this.d, this.scale, this.roundingMode));
        }
        catch (ArithmeticException arithmeticException) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NOT_ALLOWED, new Object[0]);
        }
    }

    @Override
    public BigReal multiply(BigReal bigReal) {
        return new BigReal(this.d.multiply(bigReal.d));
    }

    @Override
    public BigReal multiply(int n) {
        return new BigReal(this.d.multiply(new BigDecimal(n)));
    }

    @Override
    public int compareTo(BigReal bigReal) {
        return this.d.compareTo(bigReal.d);
    }

    public double doubleValue() {
        return this.d.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BigReal) {
            return this.d.equals(((BigReal)object).d);
        }
        return false;
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    @Override
    public Field<BigReal> getField() {
        return BigRealField.getInstance();
    }
}

