/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.MathIllegalStateException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.DoubleArray;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class ResizableDoubleArray
implements DoubleArray,
Serializable {
    private static final long serialVersionUID = -3485529955529426875L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final double DEFAULT_EXPANSION_FACTOR = 2.0;
    private static final ExpansionMode DEFAULT_EXPANSION_MODE = ExpansionMode.MULTIPLICATIVE;
    private static final double DEFAULT_CONTRACTION_DELTA = 0.5;
    private final double contractionCriterion;
    private final double expansionFactor;
    private final ExpansionMode expansionMode;
    private double[] internalArray;
    private int numElements = 0;
    private int startIndex = 0;

    public ResizableDoubleArray() {
        this(16);
    }

    public ResizableDoubleArray(int n) throws MathIllegalArgumentException {
        this(n, 2.0);
    }

    public ResizableDoubleArray(double[] dArray) {
        this(dArray == null || dArray.length == 0 ? 16 : dArray.length, 2.0, 2.5, DEFAULT_EXPANSION_MODE, dArray);
    }

    public ResizableDoubleArray(int n, double d) throws MathIllegalArgumentException {
        this(n, d, 0.5 + d);
    }

    public ResizableDoubleArray(int n, double d, double d2) throws MathIllegalArgumentException {
        this(n, d, d2, DEFAULT_EXPANSION_MODE, null);
    }

    public ResizableDoubleArray(int n, double d, double d2, ExpansionMode expansionMode, double ... dArray) throws MathIllegalArgumentException {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INITIAL_CAPACITY_NOT_POSITIVE, n);
        }
        this.checkContractExpand(d2, d);
        MathUtils.checkNotNull((Object)expansionMode);
        this.expansionFactor = d;
        this.contractionCriterion = d2;
        this.expansionMode = expansionMode;
        this.internalArray = new double[n];
        this.numElements = 0;
        this.startIndex = 0;
        if (dArray != null && dArray.length > 0) {
            this.addElements(dArray);
        }
    }

    public ResizableDoubleArray(ResizableDoubleArray resizableDoubleArray) throws NullArgumentException {
        MathUtils.checkNotNull(resizableDoubleArray);
        this.contractionCriterion = resizableDoubleArray.contractionCriterion;
        this.expansionFactor = resizableDoubleArray.expansionFactor;
        this.expansionMode = resizableDoubleArray.expansionMode;
        this.internalArray = new double[resizableDoubleArray.internalArray.length];
        System.arraycopy(resizableDoubleArray.internalArray, 0, this.internalArray, 0, this.internalArray.length);
        this.numElements = resizableDoubleArray.numElements;
        this.startIndex = resizableDoubleArray.startIndex;
    }

    @Override
    public void addElement(double d) {
        if (this.internalArray.length <= this.startIndex + this.numElements) {
            this.expand();
        }
        this.internalArray[this.startIndex + this.numElements++] = d;
    }

    @Override
    public void addElements(double[] dArray) {
        double[] dArray2 = new double[this.numElements + dArray.length + 1];
        System.arraycopy(this.internalArray, this.startIndex, dArray2, 0, this.numElements);
        System.arraycopy(dArray, 0, dArray2, this.numElements, dArray.length);
        this.internalArray = dArray2;
        this.startIndex = 0;
        this.numElements += dArray.length;
    }

    @Override
    public double addElementRolling(double d) {
        double d2 = this.internalArray[this.startIndex];
        if (this.startIndex + (this.numElements + 1) > this.internalArray.length) {
            this.expand();
        }
        ++this.startIndex;
        this.internalArray[this.startIndex + (this.numElements - 1)] = d;
        if (this.shouldContract()) {
            this.contract();
        }
        return d2;
    }

    public double substituteMostRecentElement(double d) throws MathIllegalStateException {
        if (this.numElements < 1) {
            throw new MathIllegalStateException(LocalizedFormats.CANNOT_SUBSTITUTE_ELEMENT_FROM_EMPTY_ARRAY, new Object[0]);
        }
        int n = this.startIndex + (this.numElements - 1);
        double d2 = this.internalArray[n];
        this.internalArray[n] = d;
        return d2;
    }

    protected void checkContractExpand(double d, double d2) throws NumberIsTooSmallException {
        if (d < d2) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, true);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_EXPANSION_FACTOR, d, d2);
            throw numberIsTooSmallException;
        }
        if (d <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_ONE, d);
            throw numberIsTooSmallException;
        }
        if (d2 <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.EXPANSION_FACTOR_SMALLER_THAN_ONE, d2);
            throw numberIsTooSmallException;
        }
    }

    @Override
    public void clear() {
        this.numElements = 0;
        this.startIndex = 0;
    }

    public void contract() {
        double[] dArray = new double[this.numElements + 1];
        System.arraycopy(this.internalArray, this.startIndex, dArray, 0, this.numElements);
        this.internalArray = dArray;
        this.startIndex = 0;
    }

    public void discardFrontElements(int n) throws MathIllegalArgumentException {
        this.discardExtremeElements(n, true);
    }

    public void discardMostRecentElements(int n) throws MathIllegalArgumentException {
        this.discardExtremeElements(n, false);
    }

    private void discardExtremeElements(int n, boolean bl) throws MathIllegalArgumentException {
        if (n > this.numElements) {
            throw new MathIllegalArgumentException(LocalizedFormats.TOO_MANY_ELEMENTS_TO_DISCARD_FROM_ARRAY, n, this.numElements);
        }
        if (n < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_DISCARD_NEGATIVE_NUMBER_OF_ELEMENTS, n);
        }
        this.numElements -= n;
        if (bl) {
            this.startIndex += n;
        }
        if (this.shouldContract()) {
            this.contract();
        }
    }

    protected void expand() {
        int n = 0;
        n = this.expansionMode == ExpansionMode.MULTIPLICATIVE ? (int)FastMath.ceil((double)this.internalArray.length * this.expansionFactor) : (int)((long)this.internalArray.length + FastMath.round(this.expansionFactor));
        double[] dArray = new double[n];
        System.arraycopy(this.internalArray, 0, dArray, 0, this.internalArray.length);
        this.internalArray = dArray;
    }

    private void expandTo(int n) {
        double[] dArray = new double[n];
        System.arraycopy(this.internalArray, 0, dArray, 0, this.internalArray.length);
        this.internalArray = dArray;
    }

    public double getContractionCriterion() {
        return this.contractionCriterion;
    }

    @Override
    public double getElement(int n) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n >= 0) {
            return this.internalArray[this.startIndex + n];
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    public double[] getElements() {
        double[] dArray = new double[this.numElements];
        System.arraycopy(this.internalArray, this.startIndex, dArray, 0, this.numElements);
        return dArray;
    }

    public double getExpansionFactor() {
        return this.expansionFactor;
    }

    public ExpansionMode getExpansionMode() {
        return this.expansionMode;
    }

    public int getCapacity() {
        return this.internalArray.length;
    }

    @Override
    public int getNumElements() {
        return this.numElements;
    }

    protected double[] getArrayRef() {
        return this.internalArray;
    }

    protected int getStartIndex() {
        return this.startIndex;
    }

    public double compute(MathArrays.Function function) {
        return function.evaluate(this.internalArray, this.startIndex, this.numElements);
    }

    @Override
    public void setElement(int n, double d) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n + 1 > this.numElements) {
            this.numElements = n + 1;
        }
        if (this.startIndex + n >= this.internalArray.length) {
            this.expandTo(this.startIndex + (n + 1));
        }
        this.internalArray[this.startIndex + n] = d;
    }

    public void setNumElements(int n) throws MathIllegalArgumentException {
        if (n < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.INDEX_NOT_POSITIVE, n);
        }
        int n2 = this.startIndex + n;
        if (n2 > this.internalArray.length) {
            this.expandTo(n2);
        }
        this.numElements = n;
    }

    private boolean shouldContract() {
        if (this.expansionMode == ExpansionMode.MULTIPLICATIVE) {
            return (double)((float)this.internalArray.length / (float)this.numElements) > this.contractionCriterion;
        }
        return (double)(this.internalArray.length - this.numElements) > this.contractionCriterion;
    }

    public ResizableDoubleArray copy() {
        return new ResizableDoubleArray(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ResizableDoubleArray)) {
            return false;
        }
        boolean bl = true;
        ResizableDoubleArray resizableDoubleArray = (ResizableDoubleArray)object;
        bl = bl && resizableDoubleArray.contractionCriterion == this.contractionCriterion;
        bl = bl && resizableDoubleArray.expansionFactor == this.expansionFactor;
        bl = bl && resizableDoubleArray.expansionMode == this.expansionMode;
        bl = bl && resizableDoubleArray.numElements == this.numElements;
        boolean bl2 = bl = bl && resizableDoubleArray.startIndex == this.startIndex;
        if (!bl) {
            return false;
        }
        return Arrays.equals(this.internalArray, resizableDoubleArray.internalArray);
    }

    public int hashCode() {
        int[] nArray = new int[]{Double.valueOf(this.expansionFactor).hashCode(), Double.valueOf(this.contractionCriterion).hashCode(), this.expansionMode.hashCode(), Arrays.hashCode(this.internalArray), this.numElements, this.startIndex};
        return Arrays.hashCode(nArray);
    }

    public static enum ExpansionMode {
        MULTIPLICATIVE,
        ADDITIVE;

    }
}

