/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

public class LogNormalSampler
implements ContinuousSampler {
    private final double scale;
    private final double shape;
    private final NormalizedGaussianSampler gaussian;

    public LogNormalSampler(NormalizedGaussianSampler normalizedGaussianSampler, double d, double d2) {
        if (d < 0.0) {
            throw new IllegalArgumentException("scale is not positive: " + d);
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("shape is not strictly positive: " + d2);
        }
        this.scale = d;
        this.shape = d2;
        this.gaussian = normalizedGaussianSampler;
    }

    @Override
    public double sample() {
        return Math.exp(this.scale + this.shape * this.gaussian.sample());
    }

    public String toString() {
        return "Log-normal deviate [" + this.gaussian.toString() + "]";
    }
}

