/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.int_double;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.continuous.int_double.IntToDoubleContinuousCurve;
import org.apache.commons.math4.distribution.EnumeratedRealDistribution;

@ThreadSafeMapper
@Categories(value={Category.distributions})
public class Enumerated
extends IntToDoubleContinuousCurve {
    @Examples(value={@Example(value={"Enumerated('1 2 3 4 5 6')", "a fair six-sided die roll", "[1-10]/"}), @Example(value={"Enumerated('1:2.0 2 3 4 5 6')", "an unfair six-sided die roll, where 1 has probability mass 2.0, and everything else has only 1.0"})})
    public Enumerated(String string, String ... stringArray) {
        super(new EnumeratedRealDistribution(Enumerated.parseWeights(string)[0], Enumerated.parseWeights(string)[1]), stringArray);
    }

    private static double[][] parseWeights(String string) {
        String[] stringArray = string.split("[;, ]");
        double[][] dArray = new double[2][stringArray.length];
        block4: for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            dArray[1][i] = 1.0;
            switch (stringArray2.length) {
                case 2: {
                    dArray[1][i] = Double.parseDouble(stringArray2[1]);
                }
                case 1: {
                    dArray[0][i] = Double.parseDouble(stringArray2[0]);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unable to parse entry or weight from '" + stringArray[i] + "'");
                }
            }
        }
        return dArray;
    }
}

