/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.int_double;

import io.virtdata.continuous.common.InterpolatingIntDoubleSampler;
import io.virtdata.continuous.common.RealDistributionICDSource;
import io.virtdata.continuous.common.RealIntDoubleSampler;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.IntToDoubleFunction;

public class IntToDoubleContinuousCurve
implements IntToDoubleFunction {
    private ContinuousDistribution distribution;
    private IntToDoubleFunction function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    public static final String CLAMP = "clamp";
    public static final String NOCLAMP = "noclamp";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(IntToDoubleContinuousCurve.COMPUTE);
            this.add(IntToDoubleContinuousCurve.INTERPOLATE);
            this.add(IntToDoubleContinuousCurve.MAP);
            this.add(IntToDoubleContinuousCurve.HASH);
            this.add(IntToDoubleContinuousCurve.CLAMP);
            this.add(IntToDoubleContinuousCurve.NOCLAMP);
        }
    };

    public IntToDoubleContinuousCurve(ContinuousDistribution continuousDistribution, String ... stringArray) {
        this.distribution = continuousDistribution;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        RealDistributionICDSource realDistributionICDSource = new RealDistributionICDSource(continuousDistribution);
        if (hashSet.contains(HASH) && hashSet.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (hashSet.contains(INTERPOLATE) && hashSet.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        if (hashSet.contains(CLAMP) && hashSet.contains(NOCLAMP)) {
            throw new RuntimeException("mods must not contain both clamp and noclamp.");
        }
        for (String string : stringArray) {
            if (validModifiers.contains(string)) continue;
            throw new RuntimeException("modifier '" + string + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean bl = hashSet.contains(HASH) || !hashSet.contains(MAP);
        int n = hashSet.contains(INTERPOLATE) || !hashSet.contains(COMPUTE) ? 1 : 0;
        int n2 = hashSet.contains(CLAMP) || !hashSet.contains(NOCLAMP) ? 1 : 0;
        this.function = n != 0 ? new InterpolatingIntDoubleSampler(realDistributionICDSource, 1000, bl, n2 != 0, 9.223372036854776E18) : new RealIntDoubleSampler(realDistributionICDSource, bl, n2 != 0, 9.223372036854776E18);
    }

    @Override
    public double applyAsDouble(int n) {
        return this.function.applyAsDouble(n);
    }
}

