/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics;

import io.virtdata.shaded.oac.statistics.Frequency;
import io.virtdata.shaded.oac.statistics.descriptive.DescriptiveStatistics;
import io.virtdata.shaded.oac.statistics.descriptive.UnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.moment.GeometricMean;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Mean;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Variance;
import io.virtdata.shaded.oac.statistics.descriptive.rank.Max;
import io.virtdata.shaded.oac.statistics.descriptive.rank.Min;
import io.virtdata.shaded.oac.statistics.descriptive.rank.Percentile;
import io.virtdata.shaded.oac.statistics.descriptive.summary.Product;
import io.virtdata.shaded.oac.statistics.descriptive.summary.Sum;
import io.virtdata.shaded.oac.statistics.descriptive.summary.SumOfLogs;
import io.virtdata.shaded.oac.statistics.descriptive.summary.SumOfSquares;
import java.util.List;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;

public final class StatUtils {
    private static final UnivariateStatistic SUM = new Sum();
    private static final UnivariateStatistic SUM_OF_SQUARES = new SumOfSquares();
    private static final UnivariateStatistic PRODUCT = new Product();
    private static final UnivariateStatistic SUM_OF_LOGS = new SumOfLogs();
    private static final UnivariateStatistic MIN = new Min();
    private static final UnivariateStatistic MAX = new Max();
    private static final UnivariateStatistic MEAN = new Mean();
    private static final Variance VARIANCE = new Variance();
    private static final Percentile PERCENTILE = new Percentile();
    private static final GeometricMean GEOMETRIC_MEAN = new GeometricMean();

    private StatUtils() {
    }

    public static double sum(double[] dArray) throws MathIllegalArgumentException {
        return SUM.evaluate(dArray);
    }

    public static double sum(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return SUM.evaluate(dArray, n, n2);
    }

    public static double sumSq(double[] dArray) throws MathIllegalArgumentException {
        return SUM_OF_SQUARES.evaluate(dArray);
    }

    public static double sumSq(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return SUM_OF_SQUARES.evaluate(dArray, n, n2);
    }

    public static double product(double[] dArray) throws MathIllegalArgumentException {
        return PRODUCT.evaluate(dArray);
    }

    public static double product(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return PRODUCT.evaluate(dArray, n, n2);
    }

    public static double sumLog(double[] dArray) throws MathIllegalArgumentException {
        return SUM_OF_LOGS.evaluate(dArray);
    }

    public static double sumLog(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return SUM_OF_LOGS.evaluate(dArray, n, n2);
    }

    public static double mean(double[] dArray) throws MathIllegalArgumentException {
        return MEAN.evaluate(dArray);
    }

    public static double mean(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return MEAN.evaluate(dArray, n, n2);
    }

    public static double geometricMean(double[] dArray) throws MathIllegalArgumentException {
        return GEOMETRIC_MEAN.evaluate(dArray);
    }

    public static double geometricMean(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return GEOMETRIC_MEAN.evaluate(dArray, n, n2);
    }

    public static double variance(double[] dArray) throws MathIllegalArgumentException {
        return VARIANCE.evaluate(dArray);
    }

    public static double variance(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return VARIANCE.evaluate(dArray, n, n2);
    }

    public static double variance(double[] dArray, double d, int n, int n2) throws MathIllegalArgumentException {
        return VARIANCE.evaluate(dArray, d, n, n2);
    }

    public static double variance(double[] dArray, double d) throws MathIllegalArgumentException {
        return VARIANCE.evaluate(dArray, d);
    }

    public static double populationVariance(double[] dArray) throws MathIllegalArgumentException {
        return new Variance(false).evaluate(dArray);
    }

    public static double populationVariance(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return new Variance(false).evaluate(dArray, n, n2);
    }

    public static double populationVariance(double[] dArray, double d, int n, int n2) throws MathIllegalArgumentException {
        return new Variance(false).evaluate(dArray, d, n, n2);
    }

    public static double populationVariance(double[] dArray, double d) throws MathIllegalArgumentException {
        return new Variance(false).evaluate(dArray, d);
    }

    public static double max(double[] dArray) throws MathIllegalArgumentException {
        return MAX.evaluate(dArray);
    }

    public static double max(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return MAX.evaluate(dArray, n, n2);
    }

    public static double min(double[] dArray) throws MathIllegalArgumentException {
        return MIN.evaluate(dArray);
    }

    public static double min(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return MIN.evaluate(dArray, n, n2);
    }

    public static double percentile(double[] dArray, double d) throws MathIllegalArgumentException {
        return PERCENTILE.evaluate(dArray, d);
    }

    public static double percentile(double[] dArray, int n, int n2, double d) throws MathIllegalArgumentException {
        return PERCENTILE.evaluate(dArray, n, n2, d);
    }

    public static double sumDifference(double[] dArray, double[] dArray2) throws DimensionMismatchException, NoDataException {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new DimensionMismatchException(n, dArray2.length);
        }
        if (n <= 0) {
            throw new NoDataException(LocalizedFormats.INSUFFICIENT_DIMENSION);
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] - dArray2[i];
        }
        return d;
    }

    public static double meanDifference(double[] dArray, double[] dArray2) throws DimensionMismatchException, NoDataException {
        return StatUtils.sumDifference(dArray, dArray2) / (double)dArray.length;
    }

    public static double varianceDifference(double[] dArray, double[] dArray2, double d) throws DimensionMismatchException, NumberIsTooSmallException {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new DimensionMismatchException(n, dArray2.length);
        }
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        for (int i = 0; i < n; ++i) {
            d4 = dArray[i] - dArray2[i];
            d2 += (d4 - d) * (d4 - d);
            d3 += d4 - d;
        }
        return (d2 - d3 * d3 / (double)n) / (double)(n - 1);
    }

    public static double[] normalize(double[] dArray) {
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
        for (int i = 0; i < dArray.length; ++i) {
            descriptiveStatistics.addValue(dArray[i]);
        }
        double d = descriptiveStatistics.getMean();
        double d2 = descriptiveStatistics.getStandardDeviation();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = (dArray[i] - d) / d2;
        }
        return dArray2;
    }

    public static double[] mode(double[] dArray) throws MathIllegalArgumentException {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return StatUtils.getMode(dArray, 0, dArray.length);
    }

    public static double[] mode(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, n);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
        }
        return StatUtils.getMode(dArray, n, n2);
    }

    private static double[] getMode(double[] dArray, int n, int n2) {
        Frequency<Double> frequency = new Frequency<Double>();
        for (int i = n; i < n + n2; ++i) {
            double d = dArray[i];
            if (Double.isNaN(d)) continue;
            frequency.addValue(d);
        }
        List list = frequency.getMode();
        double[] dArray2 = new double[list.size()];
        int n3 = 0;
        for (Double d : list) {
            dArray2[n3++] = d;
        }
        return dArray2;
    }
}

